/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.util;

import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.ServerOpListEntry;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.ServerLevelData;

public class PlayerUtils {
    public static boolean canTeleport(MinecraftServer server, Player player) {
        return PlayerUtils.cheatModeEnabled(server, player) || PlayerUtils.isOp(player);
    }

    public static boolean cheatModeEnabled(MinecraftServer server, Player player) {
        LevelData levelData;
        if (server != null && server.isSingleplayer() && (levelData = server.getLevel(player.level().dimension()).getLevelData()) instanceof ServerLevelData) {
            return ((ServerLevelData)levelData).isAllowCommands();
        }
        return false;
    }

    public static boolean isOp(Player player) {
        if (player instanceof ServerPlayer) {
            ServerOpListEntry userEntry = (ServerOpListEntry)((ServerPlayer)player).level().getServer().getPlayerList().getOps().get((Object)player.nameAndId());
            return userEntry != null;
        }
        return false;
    }
}

