/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.gui;

import com.chaosthedude.explorerscompass.gui.ExplorersCompassScreen;
import com.chaosthedude.explorerscompass.gui.StructureSearchEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class StructureSearchList
extends ObjectSelectionList<StructureSearchEntry> {
    private final ExplorersCompassScreen parentScreen;
    private int itemHeight;

    public StructureSearchList(ExplorersCompassScreen parentScreen, Minecraft mc, int width, int height, int y, int itemHeight) {
        super(mc, width, height, y, itemHeight);
        this.parentScreen = parentScreen;
        this.itemHeight = itemHeight;
        this.refreshList();
    }

    protected int scrollBarX() {
        return this.getRowLeft() + this.getRowWidth() - 2;
    }

    public int getRowWidth() {
        return super.getRowWidth() + 50;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.fill(this.getRowLeft() - 4, this.getY(), this.getRowLeft() + this.getRowWidth() + 4, this.getY() + this.getHeight() + 4, 0x7F000000);
        this.enableScissor(guiGraphics);
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (this.getRowBottom(i) < this.getY() || this.getRowTop(i) > this.getBottom()) continue;
            StructureSearchEntry entry = (StructureSearchEntry)((Object)this.children().get(i));
            if (entry == this.getSelected()) {
                guiGraphics.fill(this.getRowLeft() - 4, this.getRowTop(i) - 4, this.getRowLeft() + this.getRowWidth() + 4, this.getRowTop(i) + this.itemHeight, 0x7F000000);
            }
            entry.renderContent(guiGraphics, mouseX, mouseY, entry == this.getHovered(), partialTicks);
        }
        guiGraphics.disableScissor();
        if (this.maxScrollAmount() > 0) {
            int left = this.scrollBarX();
            int right = left + 6;
            int height = (int)((float)((this.getBottom() - this.getY()) * (this.getBottom() - this.getY())) / (float)this.contentHeight());
            height = Mth.clamp((int)height, (int)32, (int)(this.getBottom() - this.getY() - 8));
            int top = (int)this.scrollAmount() * (this.getBottom() - this.getY() - height) / this.maxScrollAmount() + this.getY();
            if (top < this.getY()) {
                top = this.getY();
            }
            guiGraphics.fill(left, this.getY(), right, this.getBottom(), 0x2B000000);
            guiGraphics.fill(left, top, right, top + height, -234881024);
        }
    }

    protected void enableScissor(GuiGraphics guiGraphics) {
        guiGraphics.enableScissor(this.getX(), this.getY(), this.getRight(), this.getBottom());
    }

    public int getRowBottom(int index) {
        return this.getRowTop(index) + this.itemHeight;
    }

    public void refreshList() {
        this.clearEntries();
        for (ResourceLocation key : this.parentScreen.sortStructures()) {
            this.addEntry((AbstractSelectionList.Entry)new StructureSearchEntry(this, key));
        }
        this.selectStructure(null);
        this.setScrollAmount(0.0);
    }

    public void selectStructure(StructureSearchEntry entry) {
        this.setSelected((AbstractSelectionList.Entry)entry);
        this.parentScreen.selectStructure(entry);
    }

    public boolean hasSelection() {
        return this.getSelected() != null;
    }

    public ExplorersCompassScreen getParentScreen() {
        return this.parentScreen;
    }
}

