/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.gui;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.chaosthedude.explorerscompass.gui.ExplorersCompassScreen;
import com.chaosthedude.explorerscompass.gui.StructureSearchList;
import com.chaosthedude.explorerscompass.util.StructureUtils;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;

public class StructureSearchEntry
extends ObjectSelectionList.Entry<StructureSearchEntry> {
    private final Minecraft mc;
    private final ExplorersCompassScreen parentScreen;
    private final ResourceLocation structureKey;
    private final StructureSearchList structuresList;

    public StructureSearchEntry(StructureSearchList structuresList, ResourceLocation structureKey) {
        this.structuresList = structuresList;
        this.structureKey = structureKey;
        this.parentScreen = structuresList.getParentScreen();
        this.mc = Minecraft.getInstance();
    }

    public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean isHovering, float partialTick) {
        guiGraphics.drawString(this.mc.font, (Component)Component.literal((String)StructureUtils.getPrettyStructureName(this.structureKey)), this.getX() + 1, this.getY() + 1, -1);
        Font font = this.mc.font;
        MutableComponent mutableComponent = Component.translatable((String)"string.explorerscompass.source").append((Component)Component.literal((String)(": " + StructureUtils.getPrettyStructureSource(this.structureKey))));
        int n = this.getX() + 1;
        int n2 = this.getY();
        Objects.requireNonNull(this.mc.font);
        guiGraphics.drawString(font, (Component)mutableComponent, n, n2 + 9 + 3, -8355712);
        Font font2 = this.mc.font;
        MutableComponent mutableComponent2 = Component.translatable((String)"string.explorerscompass.group").append((Component)Component.literal((String)": ")).append((Component)Component.translatable((String)StructureUtils.getPrettyStructureName(ExplorersCompass.structureKeysToTypeKeys.get(this.structureKey))));
        int n3 = this.getX() + 1;
        int n4 = this.getY();
        Objects.requireNonNull(this.mc.font);
        guiGraphics.drawString(font2, (Component)mutableComponent2, n3, n4 + 9 + 14, -8355712);
        Font font3 = this.mc.font;
        MutableComponent mutableComponent3 = Component.translatable((String)"string.explorerscompass.dimension").append((Component)Component.literal((String)(": " + StructureUtils.dimensionKeysToString(ExplorersCompass.dimensionKeysForAllowedStructureKeys.get((Object)this.structureKey)))));
        int n5 = this.getX() + 1;
        int n6 = this.getY();
        Objects.requireNonNull(this.mc.font);
        guiGraphics.drawString(font3, (Component)mutableComponent3, n5, n6 + 9 + 25, -8355712);
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        this.structuresList.selectStructure(this);
        if (doubleClick) {
            this.searchForStructure();
        }
        return true;
    }

    public Component getNarration() {
        return Component.literal((String)StructureUtils.getPrettyStructureName(this.structureKey));
    }

    public void searchForStructure() {
        this.mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        this.parentScreen.searchForStructure(this.structureKey);
    }

    public void searchForGroup() {
        this.mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
        this.parentScreen.searchForGroup(ExplorersCompass.structureKeysToTypeKeys.get(this.structureKey));
    }
}

