/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.gui;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.chaosthedude.explorerscompass.gui.StructureSearchEntry;
import com.chaosthedude.explorerscompass.gui.StructureSearchList;
import com.chaosthedude.explorerscompass.gui.TransparentButton;
import com.chaosthedude.explorerscompass.gui.TransparentTextField;
import com.chaosthedude.explorerscompass.items.ExplorersCompassItem;
import com.chaosthedude.explorerscompass.network.SearchPacket;
import com.chaosthedude.explorerscompass.network.TeleportPacket;
import com.chaosthedude.explorerscompass.sorting.ISorting;
import com.chaosthedude.explorerscompass.sorting.NameSorting;
import com.chaosthedude.explorerscompass.util.CompassState;
import com.chaosthedude.explorerscompass.util.StructureUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class ExplorersCompassScreen
extends Screen {
    private Level level;
    private Player player;
    private List<ResourceLocation> allowedStructureKeys;
    private List<ResourceLocation> structureKeysMatchingSearch;
    private ItemStack stack;
    private ExplorersCompassItem explorersCompass;
    private Button searchButton;
    private Button searchGroupButton;
    private Button sortByButton;
    private Button teleportButton;
    private Button cancelButton;
    private TransparentTextField searchTextField;
    private StructureSearchList selectionList;
    private ISorting sortingCategory;

    public ExplorersCompassScreen(Level level, Player player, ItemStack stack, ExplorersCompassItem explorersCompass, List<ResourceLocation> allowedStructureKeys) {
        super((Component)Component.translatable((String)"string.explorerscompass.selectStructure"));
        this.level = level;
        this.player = player;
        this.stack = stack;
        this.explorersCompass = explorersCompass;
        this.allowedStructureKeys = new ArrayList<ResourceLocation>(allowedStructureKeys);
        this.structureKeysMatchingSearch = new ArrayList<ResourceLocation>(this.allowedStructureKeys);
        this.sortingCategory = new NameSorting();
    }

    public boolean mouseScrolled(double par1, double par2, double par3, double par4) {
        return this.selectionList.mouseScrolled(par1, par2, par3, par4);
    }

    protected void init() {
        this.setupWidgets();
    }

    public void tick() {
        boolean bl = this.teleportButton.active = this.explorersCompass.getState(this.stack) == CompassState.FOUND;
        if (this.allowedStructureKeys.size() != ExplorersCompass.allowedStructureKeys.size()) {
            this.removeWidget((GuiEventListener)this.selectionList);
            this.allowedStructureKeys = new ArrayList<ResourceLocation>(ExplorersCompass.allowedStructureKeys);
            this.structureKeysMatchingSearch = new ArrayList<ResourceLocation>(this.allowedStructureKeys);
            this.selectionList = new StructureSearchList(this, this.minecraft, this.width + 110, this.height - 40, 40, 45);
            this.addRenderableWidget((GuiEventListener)this.selectionList);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawCenteredString(this.font, this.title, 65, 15, -1);
    }

    public boolean keyPressed(KeyEvent event) {
        boolean ret = super.keyPressed(event);
        if (this.searchTextField.isFocused()) {
            this.processSearchTerm();
            return true;
        }
        return ret;
    }

    public void selectStructure(StructureSearchEntry entry) {
        boolean enable;
        this.searchButton.active = enable = entry != null;
        this.searchGroupButton.active = enable;
    }

    public void searchForStructure(ResourceLocation key) {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new SearchPacket(key, List.of(key), this.player.blockPosition()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.minecraft.setScreen(null);
    }

    public void searchForGroup(ResourceLocation key) {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new SearchPacket(key, ExplorersCompass.typeKeysToStructureKeys.get((Object)key), this.player.blockPosition()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.minecraft.setScreen(null);
    }

    public void teleport() {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new TeleportPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.minecraft.setScreen(null);
    }

    public void processSearchTerm() {
        this.structureKeysMatchingSearch = new ArrayList<ResourceLocation>();
        String searchTerm = this.searchTextField.getValue().toLowerCase();
        for (ResourceLocation key : this.allowedStructureKeys) {
            if (searchTerm.startsWith("@")) {
                if (!StructureUtils.getPrettyStructureSource(key).toLowerCase().contains(searchTerm.substring(1))) continue;
                this.structureKeysMatchingSearch.add(key);
                continue;
            }
            if (!StructureUtils.getPrettyStructureName(key).toLowerCase().contains(searchTerm)) continue;
            this.structureKeysMatchingSearch.add(key);
        }
        this.selectionList.refreshList();
    }

    public List<ResourceLocation> sortStructures() {
        List<ResourceLocation> structures = this.structureKeysMatchingSearch;
        Collections.sort(structures, new NameSorting());
        Collections.sort(structures, this.sortingCategory);
        return structures;
    }

    private void setupWidgets() {
        this.clearWidgets();
        this.searchButton = (Button)this.addRenderableWidget((GuiEventListener)new TransparentButton(10, 40, 110, 20, (Component)Component.translatable((String)"string.explorerscompass.search"), onPress -> {
            if (this.selectionList.hasSelection()) {
                ((StructureSearchEntry)this.selectionList.getSelected()).searchForStructure();
            }
        }));
        this.searchGroupButton = (Button)this.addRenderableWidget((GuiEventListener)new TransparentButton(10, 65, 110, 20, (Component)Component.translatable((String)"string.explorerscompass.searchForGroup"), onPress -> {
            if (this.selectionList.hasSelection()) {
                ((StructureSearchEntry)this.selectionList.getSelected()).searchForGroup();
            }
        }));
        this.sortByButton = (Button)this.addRenderableWidget((GuiEventListener)new TransparentButton(10, 90, 110, 20, (Component)Component.translatable((String)"string.explorerscompass.sortBy").append((Component)Component.literal((String)(": " + this.sortingCategory.getLocalizedName()))), onPress -> {
            this.sortingCategory = this.sortingCategory.next();
            this.sortByButton.setMessage((Component)Component.translatable((String)"string.explorerscompass.sortBy").append((Component)Component.literal((String)(": " + this.sortingCategory.getLocalizedName()))));
            this.selectionList.refreshList();
        }));
        this.cancelButton = (Button)this.addRenderableWidget((GuiEventListener)new TransparentButton(10, this.height - 30, 110, 20, (Component)Component.translatable((String)"gui.cancel"), onPress -> this.minecraft.setScreen(null)));
        this.teleportButton = (Button)this.addRenderableWidget((GuiEventListener)new TransparentButton(this.width - 120, 10, 110, 20, (Component)Component.translatable((String)"string.explorerscompass.teleport"), onPress -> this.teleport()));
        this.searchButton.active = false;
        this.searchGroupButton.active = false;
        this.teleportButton.visible = ExplorersCompass.canTeleport;
        this.searchTextField = new TransparentTextField(this.font, this.width / 2 - 82, 10, 140, 20, (Component)Component.translatable((String)"string.explorerscompass.search"));
        this.addRenderableWidget((GuiEventListener)this.searchTextField);
        if (this.selectionList == null) {
            this.selectionList = new StructureSearchList(this, this.minecraft, this.width + 110, this.height - 40, 40, 45);
        }
        this.addRenderableWidget((GuiEventListener)this.selectionList);
    }
}

