/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.client;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.chaosthedude.explorerscompass.items.ExplorersCompassItem;
import com.chaosthedude.explorerscompass.util.CompassState;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.properties.numeric.NeedleDirectionHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class ExplorersCompassAngleState
extends NeedleDirectionHelper {
    private final NeedleDirectionHelper.Wobbler wobbler;
    private final RandomSource random = RandomSource.create();

    public ExplorersCompassAngleState() {
        super(true);
        this.wobbler = this.newWobbler(0.8f);
    }

    protected float calculate(ItemStack stack, ClientLevel level, int seed, ItemOwner owner) {
        ExplorersCompassItem compassItem;
        GlobalPos pos = level.getRespawnData().globalPos();
        if (stack.getItem() == ExplorersCompass.explorersCompass && (compassItem = (ExplorersCompassItem)stack.getItem()).getState(stack) == CompassState.FOUND) {
            pos = new GlobalPos(level.dimension(), new BlockPos(compassItem.getFoundStructureX(stack), 0, compassItem.getFoundStructureZ(stack)));
        }
        long gameTime = level.getGameTime();
        return owner.asLivingEntity() == null || !ExplorersCompassAngleState.isValidCompassTargetPos((Entity)owner.asLivingEntity(), pos) ? this.getRandomlySpinningRotation(seed, gameTime) : this.getRotationTowardsCompassTarget((Entity)owner.asLivingEntity(), gameTime, pos.pos());
    }

    private float getRandomlySpinningRotation(int seed, long gameTime) {
        if (this.wobbler.shouldUpdate(gameTime)) {
            this.wobbler.update(gameTime, this.random.nextFloat());
        }
        float f = this.wobbler.rotation() + (float)ExplorersCompassAngleState.hash(seed) / 2.1474836E9f;
        return Mth.positiveModulo((float)f, (float)1.0f);
    }

    private float getRotationTowardsCompassTarget(Entity entity, long gameTime, BlockPos pos) {
        Player player;
        float f = (float)ExplorersCompassAngleState.getAngleFromEntityToPos(entity, pos);
        float f1 = ExplorersCompassAngleState.getWrappedVisualRotationY(entity);
        if (entity instanceof Player && (player = (Player)entity).isLocalPlayer() && player.level().tickRateManager().runsNormally()) {
            if (this.wobbler.shouldUpdate(gameTime)) {
                this.wobbler.update(gameTime, 0.5f - (f1 - 0.25f));
            }
            float f3 = f + this.wobbler.rotation();
            return Mth.positiveModulo((float)f3, (float)1.0f);
        }
        float f2 = 0.5f - (f1 - 0.25f - f);
        return Mth.positiveModulo((float)f2, (float)1.0f);
    }

    private static boolean isValidCompassTargetPos(Entity entity, @Nullable GlobalPos pos) {
        return pos != null && pos.dimension() == entity.level().dimension() && !(pos.pos().distToCenterSqr((Position)entity.position()) < (double)1.0E-5f);
    }

    private static double getAngleFromEntityToPos(Entity entity, BlockPos pos) {
        Vec3 vec3 = Vec3.atCenterOf((Vec3i)pos);
        return Math.atan2(vec3.z() - entity.getZ(), vec3.x() - entity.getX()) / 6.2831854820251465;
    }

    private static float getWrappedVisualRotationY(Entity entity) {
        return Mth.positiveModulo((float)(entity.getVisualRotationYInDegrees() / 360.0f), (float)1.0f);
    }

    private static int hash(int seed) {
        return seed * 1327217883;
    }
}

