/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass;

import com.chaosthedude.explorerscompass.config.ConfigHandler;
import com.chaosthedude.explorerscompass.items.ExplorersCompassItem;
import com.chaosthedude.explorerscompass.network.SearchPacket;
import com.chaosthedude.explorerscompass.network.SyncPacket;
import com.chaosthedude.explorerscompass.network.TeleportPacket;
import com.chaosthedude.explorerscompass.worker.WorldWorkerManager;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="explorerscompass")
public class ExplorersCompass {
    public static final String MODID = "explorerscompass";
    public static final Logger LOGGER = LogManager.getLogger((String)"explorerscompass");
    public static ExplorersCompassItem explorersCompass;
    public static final DataComponentType<String> STRUCTURE_ID_COMPONENT;
    public static final DataComponentType<Integer> COMPASS_STATE_COMPONENT;
    public static final DataComponentType<Integer> FOUND_X_COMPONENT;
    public static final DataComponentType<Integer> FOUND_Z_COMPONENT;
    public static final DataComponentType<Integer> SEARCH_RADIUS_COMPONENT;
    public static final DataComponentType<Integer> SAMPLES_COMPONENT;
    public static final DataComponentType<Boolean> DISPLAY_COORDS_COMPONENT;
    public static boolean canTeleport;
    public static List<ResourceLocation> allowedStructureKeys;
    public static ListMultimap<ResourceLocation, ResourceLocation> dimensionKeysForAllowedStructureKeys;
    public static Map<ResourceLocation, ResourceLocation> structureKeysToTypeKeys;
    public static ListMultimap<ResourceLocation, ResourceLocation> typeKeysToStructureKeys;

    public ExplorersCompass(ModContainer modContainer) {
        modContainer.getEventBus().addListener(this::commonSetup);
        modContainer.getEventBus().addListener(this::buildCreativeTabContents);
        modContainer.getEventBus().addListener(this::registerPayloads);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigHandler.GENERAL_SPEC);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ConfigHandler.CLIENT_SPEC);
        NeoForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        allowedStructureKeys = new ArrayList<ResourceLocation>();
        dimensionKeysForAllowedStructureKeys = ArrayListMultimap.create();
        structureKeysToTypeKeys = new HashMap<ResourceLocation, ResourceLocation>();
        typeKeysToStructureKeys = ArrayListMultimap.create();
    }

    private void buildCreativeTabContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            event.accept(new ItemStack((ItemLike)explorersCompass));
        }
    }

    private void registerPayloads(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MODID);
        registrar.playToServer(SearchPacket.TYPE, SearchPacket.CODEC, SearchPacket::handle);
        registrar.playToServer(TeleportPacket.TYPE, TeleportPacket.CODEC, TeleportPacket::handle);
        registrar.playToClient(SyncPacket.TYPE, SyncPacket.CODEC, SyncPacket::handle);
    }

    @SubscribeEvent
    public void preServerTick(ServerTickEvent.Pre event) {
        WorldWorkerManager.tick(true);
    }

    @SubscribeEvent
    public void postServerTick(ServerTickEvent.Post event) {
        WorldWorkerManager.tick(false);
    }

    @SubscribeEvent
    public void serverStopping(ServerStoppingEvent evt) {
        WorldWorkerManager.clear();
    }

    static {
        STRUCTURE_ID_COMPONENT = DataComponentType.builder().persistent((Codec)Codec.STRING).networkSynchronized(ByteBufCodecs.STRING_UTF8).build();
        COMPASS_STATE_COMPONENT = DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.VAR_INT).build();
        FOUND_X_COMPONENT = DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.VAR_INT).build();
        FOUND_Z_COMPONENT = DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.VAR_INT).build();
        SEARCH_RADIUS_COMPONENT = DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.VAR_INT).build();
        SAMPLES_COMPONENT = DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.VAR_INT).build();
        DISPLAY_COORDS_COMPONENT = DataComponentType.builder().persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL).build();
    }
}

