/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib.util;

import blue.endless.jankson.JsonArray;
import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonObject;
import com.google.gson.JsonParser;
import de.cristelknight.cristellib.CristelLib;
import de.cristelknight.cristellib.CristelLibExpectPlatform;
import de.cristelknight.cristellib.util.jankson.CommentArray;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class JanksonUtil {
    @Nullable
    public static com.google.gson.JsonElement getSetElement(String getDataFromModId, ResourceLocation location) {
        return JanksonUtil.getElement(getDataFromModId, "data/" + location.getNamespace() + "/worldgen/structure_set/" + location.getPath() + ".json");
    }

    @Nullable
    public static com.google.gson.JsonElement getElement(String getDataFromModId, String location) {
        com.google.gson.JsonElement jsonElement;
        InputStream in = CristelLibExpectPlatform.getResourceStream(getDataFromModId, location);
        if (in == null) {
            CristelLib.LOGGER.warn("Couldn't create Input Stream for sub path {} in modId {}", (Object)location, (Object)getDataFromModId);
            return null;
        }
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        try {
            jsonElement = JsonParser.parseReader((Reader)reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                CristelLib.LOGGER.warn("Couldn't read {} from mod: {}", (Object)location, (Object)getDataFromModId, (Object)e);
                return null;
            }
        }
        reader.close();
        return jsonElement;
    }

    public static JsonObject addCommentsAndAlphabeticallySortRecursively(Map<String, String> comments, JsonObject object, String parentKey, boolean alphabeticallySorted) {
        if (comments.isEmpty() && !alphabeticallySorted) {
            return object;
        }
        for (Map.Entry entry2 : object.entrySet()) {
            JsonElement value;
            String objectKey = (String)entry2.getKey();
            String commentsKey = parentKey + objectKey;
            String comment = object.getComment((String)entry2.getKey());
            if (comments.containsKey(commentsKey) && comment == null) {
                String commentToAdd = comments.get(commentsKey);
                object.setComment(objectKey, commentToAdd);
                comment = commentToAdd;
            }
            if ((value = (JsonElement)entry2.getValue()) instanceof JsonArray) {
                JsonArray array = (JsonArray)value;
                JsonArray sortedJsonElements = new JsonArray();
                for (JsonElement element : array) {
                    if (element instanceof JsonObject) {
                        JsonObject nestedObject = (JsonObject)element;
                        sortedJsonElements.add((JsonElement)JanksonUtil.addCommentsAndAlphabeticallySortRecursively(comments, nestedObject, (String)entry2.getKey() + ".", alphabeticallySorted));
                        continue;
                    }
                    if (!(element instanceof JsonArray)) continue;
                    JsonArray array1 = (JsonArray)element;
                    CommentArray commentArray = new CommentArray();
                    commentArray.addAll((Collection)array1);
                    sortedJsonElements.add((JsonElement)commentArray);
                }
                if (!sortedJsonElements.isEmpty()) {
                    object.put(objectKey, (JsonElement)sortedJsonElements, comment);
                }
            }
            if (!(value instanceof JsonObject)) continue;
            JsonObject nestedObject = (JsonObject)value;
            object.put(objectKey, (JsonElement)JanksonUtil.addCommentsAndAlphabeticallySortRecursively(comments, nestedObject, (String)entry2.getKey() + ".", alphabeticallySorted), comment);
        }
        if (alphabeticallySorted) {
            JsonObject alphabeticallySortedJsonObject = new JsonObject();
            TreeMap map = new TreeMap(String::compareTo);
            map.putAll(object);
            alphabeticallySortedJsonObject.putAll(map);
            alphabeticallySortedJsonObject.forEach((key, entry) -> alphabeticallySortedJsonObject.setComment(key, object.getComment(key)));
            return alphabeticallySortedJsonObject;
        }
        return object;
    }
}

