/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.cristellib.autoconfig;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.cristelknight.cristellib.CristelLibRegistry;
import de.cristelknight.cristellib.StructureConfig;
import de.cristelknight.cristellib.autoconfig.ACConfig;
import de.cristelknight.cristellib.autoconfig.ACInfoData;
import de.cristelknight.cristellib.config.ConfigType;
import de.cristelknight.cristellib.config.simple.ConfigRegistry;
import de.cristelknight.cristellib.util.JanksonUtil;
import de.cristelknight.cristellib.util.Util;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public class ModFinder {
    public static final Set<String> supportedPlacements = Set.of("minecraft:random_spread", "moogs_structures:advanced_random_spread", "mes:advanced_random_spread", "mns:advanced_random_spread", "mss:advanced_random_spread", "mvs:advanced_random_spread", "repurposed_structures:advanced_random_spread");

    public static void addAutoConfigs(String modID, Set<String> structureSets, Map<String, Set<StructureConfig>> structureConfigData, CristelLibRegistry registry) {
        HashSet<StructureConfig> configSet = new HashSet<StructureConfig>();
        boolean customPath = ACInfoData.currentData.containsKey(modID) && !ACInfoData.currentData.get(modID).autoConfigPath().isEmpty();
        String customSubPath = ConfigRegistry.get(ACConfig.class).autoConfigSubPath();
        StructureConfig edConfig = StructureConfig.createWithDefaultConfigPath((String)(customPath ? ACInfoData.currentData.get(modID).autoConfigPath() : customSubPath + modID), "structure_toggle_config", ConfigType.ENABLE_DISABLE);
        StructureConfig placementConfig = StructureConfig.createWithDefaultConfigPath((String)(customPath ? ACInfoData.currentData.get(modID).autoConfigPath() : customSubPath + modID), "structure_placement_config", ConfigType.PLACEMENT);
        structureSets.forEach(path -> {
            JsonElement e = JanksonUtil.getElement(modID, path);
            if (e != null) {
                JsonObject object = GsonHelper.convertToJsonObject((JsonElement)e, (String)("Set at: " + path + " modId: " + modID)).getAsJsonObject("placement");
                ResourceLocation location = ModFinder.getLocation(Path.of(path, new String[0]));
                if (supportedPlacements.contains(GsonHelper.getAsString((JsonObject)object, (String)"type"))) {
                    registry.registerSetToConfig(modID, location, edConfig, placementConfig);
                } else {
                    registry.registerSetToConfig(modID, location, edConfig);
                }
            }
        });
        if (!placementConfig.isSetsEmpty()) {
            configSet.add(placementConfig);
        }
        if (!edConfig.isSetsEmpty()) {
            configSet.add(edConfig);
        }
        if (!configSet.isEmpty()) {
            configSet.forEach(config -> {
                config.getDefaultNamespace();
                config.isAutoGenerated = true;
                config.setHeader("Automatically generated by Cristel Lib");
            });
            structureConfigData.put(modID, configSet);
        }
    }

    private static ResourceLocation getLocation(Path rootPath) {
        String namespace = rootPath.getName(1).toString();
        String rawPath = Util.cutFileType(rootPath.subpath(4, rootPath.getNameCount()));
        String path = Util.normalizeResourcePath(rawPath);
        if (namespace.equals("minecraft")) {
            return ResourceLocation.withDefaultNamespace((String)path);
        }
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)path);
    }

    public static boolean shouldSkipModForACPre(String modID, Set<String> modsWithConfig) {
        return modsWithConfig.contains(modID) || modID.equals("minecraft");
    }

    public static boolean shouldSkipModForACAfter(String modID, Set<String> modsWithConfig) {
        ACConfig acConfig = ConfigRegistry.get(ACConfig.class);
        return acConfig.disableAutoConfig() || acConfig.blacklistedMods().contains(modID) || modsWithConfig.contains(modID);
    }
}

