/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.entity;

import com.mrcrayfish.goblintraders.Config;
import com.mrcrayfish.goblintraders.core.ModEntities;
import com.mrcrayfish.goblintraders.entity.AbstractGoblinEntity;
import com.mrcrayfish.goblintraders.entity.TraderCreatureEntity;
import com.mrcrayfish.goblintraders.trades.EntityTrades;
import com.mrcrayfish.goblintraders.trades.IRaritySettings;
import com.mrcrayfish.goblintraders.trades.TradeManager;
import com.mrcrayfish.goblintraders.trades.TradeRarity;
import com.mrcrayfish.goblintraders.trades.type.BaseTrade;
import com.mrcrayfish.goblintraders.util.Utils;
import java.util.List;
import java.util.Map;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class VeinGoblinTrader
extends AbstractGoblinEntity {
    private static final ResourceLocation TEXTURE = Utils.resource("textures/entity/vein_goblin_trader.png");

    public VeinGoblinTrader(EntityType<VeinGoblinTrader> type, Level level) {
        super((EntityType<? extends TraderCreatureEntity>)type, level);
    }

    @Override
    public ResourceLocation getTexture() {
        return TEXTURE;
    }

    @Override
    protected void populateTradeData() {
        MerchantOffers offers = this.getOffers();
        EntityTrades entityTrades = TradeManager.instance().getTrades((EntityType<? extends TraderCreatureEntity>)((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get()));
        if (entityTrades != null) {
            Map<TradeRarity, List<BaseTrade>> tradeMap = entityTrades.map();
            for (TradeRarity rarity : TradeRarity.values()) {
                IRaritySettings settings = Config.ENTITIES.veinGoblinTrader.trades.getSettings(rarity);
                if (settings.includeChance() <= 0.0 || settings.includeChance() < 1.0 && this.getRandom().nextDouble() > settings.includeChance()) continue;
                List<BaseTrade> trades = tradeMap.get((Object)rarity);
                int min = Math.min(settings.getMinValue(), settings.getMaxValue());
                int max = Math.max(settings.getMinValue(), settings.getMaxValue());
                int count = min + this.getRandom().nextInt(max - min + 1);
                this.addTrades(offers, trades, count, rarity.shouldShuffle());
            }
        }
    }

    @Override
    public ItemStack getFavouriteFood() {
        return new ItemStack((ItemLike)Items.CARROT);
    }

    public void aiStep() {
        if (this.isClientSide() && this.tickCount % 2 == 0) {
            this.level().addParticle((ParticleOptions)ParticleTypes.FLAME, this.getX() - 0.5 + this.getRandom().nextDouble(), this.getY() + 0.5 - 0.5 + this.getRandom().nextDouble(), this.getZ() - 0.5 + this.getRandom().nextDouble(), 0.0, 0.0, 0.0);
        }
        super.aiStep();
    }

    public boolean fireImmune() {
        return true;
    }

    @Override
    protected int getMaxRestockDelay() {
        return (Integer)Config.ENTITIES.veinGoblinTrader.restockDelay.get();
    }

    @Override
    public boolean canAttackBack() {
        return (Boolean)Config.ENTITIES.veinGoblinTrader.canAttackBack.get();
    }

    public int getAmbientSoundInterval() {
        return (Integer)Config.ENTITIES.veinGoblinTrader.gruntNoiseInterval.get();
    }
}

