/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrcrayfish.goblintraders.client.renderer.entity.GoblinModelLayers;
import com.mrcrayfish.goblintraders.client.renderer.entity.model.GoblinTraderModel;
import com.mrcrayfish.goblintraders.client.renderer.entity.state.GoblinRenderState;
import com.mrcrayfish.goblintraders.entity.AbstractGoblinEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.ArmedEntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Quaternionfc;

public class GoblinTraderRenderer
extends MobRenderer<AbstractGoblinEntity, GoblinRenderState, GoblinTraderModel> {
    public GoblinTraderRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new GoblinTraderModel(context.bakeLayer(GoblinModelLayers.GOBLIN_TRADER)), 0.5f);
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this));
    }

    public GoblinRenderState createRenderState() {
        return new GoblinRenderState();
    }

    public void extractRenderState(AbstractGoblinEntity goblin, GoblinRenderState state, float partialTick) {
        super.extractRenderState((LivingEntity)goblin, (LivingEntityRenderState)state, partialTick);
        ArmedEntityRenderState.extractArmedEntityRenderState((LivingEntity)goblin, (ArmedEntityRenderState)state, (ItemModelResolver)this.itemModelResolver);
        state.sitting = goblin.isSitting();
        state.usingItem = goblin.isUsingItem();
        state.attackTime = goblin.getAttackAnim(partialTick);
        state.holdingItem = !goblin.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty();
        state.texture = goblin.getTexture();
        state.headTilt = goblin.getHeadTilt(partialTick);
        state.armAngle = goblin.getArmAngle(partialTick);
        state.stunned = goblin.isStunned();
        state.stunRot = goblin.getStunRotation();
        state.stunCounter = (float)goblin.getFallCounter() + partialTick;
        state.alive = goblin.isAlive();
    }

    public ResourceLocation getTextureLocation(GoblinRenderState state) {
        return state.texture;
    }

    public void submit(GoblinRenderState renderState, PoseStack stack, SubmitNodeCollector collector, CameraRenderState cameraState) {
        stack.pushPose();
        if (renderState.usingItem || renderState.sitting) {
            stack.translate(0.0, -0.17, 0.0);
        }
        if (renderState.stunned && renderState.alive) {
            float progress = Math.min(10.0f, renderState.stunCounter) / 10.0f;
            stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-renderState.stunRot));
            stack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f * progress));
            stack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(renderState.stunRot));
        }
        super.submit((LivingEntityRenderState)renderState, stack, collector, cameraState);
        stack.popPose();
    }
}

