/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen.components;

import net.geforcemods.securitycraft.screen.components.IToggleableButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class TogglePictureButton
extends Button
implements IToggleableButton {
    private final ResourceLocation[] sprites;
    private final int toggleCount;
    private final int drawOffset;
    private final int drawWidth;
    private final int drawHeight;
    private int currentIndex = 0;

    public TogglePictureButton(int xPos, int yPos, int width, int height, int drawOffset, int drawWidth, int drawHeight, int toggleCount, Button.OnPress onPress, ResourceLocation ... sprites) {
        super(xPos, yPos, width, height, (Component)Component.empty(), onPress, DEFAULT_NARRATION);
        if (sprites.length != toggleCount) {
            throw new IllegalArgumentException("TogglePictureButton was set up incorrectly. Amount of sprites must match toggleCount!");
        }
        this.sprites = sprites;
        this.toggleCount = toggleCount;
        this.drawOffset = drawOffset;
        this.drawWidth = drawWidth;
        this.drawHeight = drawHeight;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(guiGraphics, mouseX, mouseX, partialTicks);
        ResourceLocation sprite = this.getCurrentSprite();
        if (sprite != null) {
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, sprite, this.getX() + this.drawOffset, this.getY() + this.drawOffset, this.drawWidth, this.drawHeight);
        }
    }

    public void onPress(InputWithModifiers input) {
        if (Minecraft.getInstance().hasShiftDown()) {
            this.setCurrentIndex(this.currentIndex - 1);
        } else {
            this.setCurrentIndex(this.currentIndex + 1);
        }
        super.onPress(input);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        this.setCurrentIndex(this.currentIndex - (int)Math.signum(scrollY));
        this.onPress.onPress((Button)this);
        return true;
    }

    @Override
    public int getCurrentIndex() {
        return this.currentIndex;
    }

    @Override
    public void setCurrentIndex(int newIndex) {
        this.currentIndex = Math.floorMod(newIndex, this.toggleCount);
    }

    public ResourceLocation getCurrentSprite() {
        return this.sprites[this.getCurrentIndex()];
    }
}

