/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.TrophySystemBlockEntity;
import net.geforcemods.securitycraft.inventory.TrophySystemMenu;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.screen.components.ToggleScrollList;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class TrophySystemScreen
extends AbstractContainerScreen<TrophySystemMenu> {
    private static final ResourceLocation GUI_TEXTURE = SecurityCraft.resLoc("textures/gui/container/trophy_system.png");
    public final Component scrollListTitle;
    public final Component smartModuleTooltip;
    private boolean hasSmartModule;
    private boolean hasRedstoneModule;
    private TrophySystemBlockEntity be;
    private ToggleScrollList<EntityType<?>> scrollList;

    public TrophySystemScreen(TrophySystemMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageHeight = 248;
        this.be = menu.be;
        this.hasSmartModule = this.be.isModuleEnabled(ModuleType.SMART);
        this.hasRedstoneModule = this.be.isModuleEnabled(ModuleType.REDSTONE);
        this.scrollListTitle = Utils.localize("gui.securitycraft:trophy_system.targetableProjectiles", new Object[0]);
        this.smartModuleTooltip = this.hasSmartModule ? Utils.localize("gui.securitycraft:trophy_system.toggle", new Object[0]) : Utils.localize("gui.securitycraft:trophy_system.moduleRequired", new Object[0]);
    }

    protected void init() {
        super.init();
        this.inventoryLabelY = this.imageHeight - 94;
        this.titleLabelX = this.imageWidth / 2 - this.font.width((FormattedText)this.title) / 2;
        this.scrollList = (ToggleScrollList)this.addRenderableWidget((GuiEventListener)new ToggleScrollList(this.be, this.hasSmartModule, this.hasRedstoneModule, this.minecraft, this.imageWidth - 24, 106, this.topPos + 40, this.leftPos + 12));
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        if (this.minecraft.player.isSpectator()) {
            return false;
        }
        return super.mouseClicked(event, doubleClick);
    }

    public boolean mouseDragged(MouseButtonEvent event, double dragX, double dragY) {
        if (this.scrollList != null && this.scrollList.mouseDragged(event, dragX, dragY)) {
            return true;
        }
        return super.mouseDragged(event, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (super.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        return this.scrollList.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        ClientUtils.renderModuleInfo(guiGraphics, this.font, ModuleType.SMART, this.smartModuleTooltip, this.hasSmartModule, this.leftPos + 5, this.topPos + 5, mouseX, mouseY);
    }

    public void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        guiGraphics.drawString(this.font, this.scrollListTitle, this.imageWidth / 2 - this.font.width((FormattedText)this.scrollListTitle) / 2, 31, -12566464, false);
    }

    public boolean keyPressed(KeyEvent event) {
        if (this.minecraft.options.keyInventory.isActiveAndMatches(InputConstants.getKey((KeyEvent)event))) {
            this.onClose();
            return true;
        }
        return super.keyPressed(event);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

