/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.geforcemods.securitycraft.components.Notes;
import net.geforcemods.securitycraft.network.server.SyncSSSSettingsOnServer;
import net.geforcemods.securitycraft.screen.components.SSSConnectionList;
import net.geforcemods.securitycraft.screen.components.TogglePictureButton;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class SonicSecuritySystemScreen
extends Screen
implements SSSConnectionList.ConnectionAccessor {
    private static final ResourceLocation TEXTURE = SecurityCraft.resLoc("textures/gui/container/sonic_security_system.png");
    private static final Component SOUND_TEXT = Utils.localize("gui.securitycraft:sonic_security_system.sound", new Object[0]);
    private static final int PLAYBACK_DELAY = 10;
    private final SonicSecuritySystemBlockEntity be;
    private int xSize = 300;
    private int ySize = 166;
    private int leftPos;
    private int topPos;
    private Button recordingButton;
    private Button clearButton;
    private Button powerButton;
    private Button playButton;
    private Button invertButton;
    private TogglePictureButton soundButton;
    private SSSConnectionList<SonicSecuritySystemScreen> connectionList;
    private boolean playback = false;
    private int tickCount = 10;
    private int currentNote = 0;
    private boolean isOwner;

    public SonicSecuritySystemScreen(SonicSecuritySystemBlockEntity be) {
        super(be.getName());
        this.be = be;
        this.isOwner = be.isOwnedBy((Entity)Minecraft.getInstance().player);
    }

    public void tick() {
        if (this.playback) {
            ++this.tickCount;
            if (this.tickCount >= 10) {
                if (this.currentNote < this.be.getNumberOfNotes()) {
                    Notes.NoteWrapper note = this.be.getRecordedNotes().get(this.currentNote++);
                    NoteBlockInstrument instrument = NoteBlockInstrument.valueOf((String)note.instrumentName().toUpperCase());
                    SoundEvent sound = instrument.hasCustomSound() && !note.customSound().isEmpty() ? SoundEvent.createVariableRangeEvent((ResourceLocation)SecurityCraft.mcResLoc(note.customSound())) : (SoundEvent)instrument.getSoundEvent().value();
                    float pitch = instrument.isTunable() ? (float)Math.pow(2.0, (double)(note.id() - 12) / 12.0) : 1.0f;
                    this.tickCount = 0;
                    this.minecraft.level.playSound((Entity)this.minecraft.player, this.be.getBlockPos(), sound, SoundSource.RECORDS, 3.0f, pitch);
                } else if (this.currentNote >= this.be.getNumberOfNotes()) {
                    this.currentNote = 0;
                    this.playback = false;
                }
            }
        }
    }

    public void init() {
        super.init();
        this.leftPos = (this.width - this.xSize) / 2;
        this.topPos = (this.height - this.ySize) / 2;
        boolean isActive = this.be.isActive();
        boolean hasNotes = this.be.getNumberOfNotes() > 0;
        int buttonX = this.leftPos + this.xSize - 155;
        this.powerButton = (Button)this.addRenderableWidget((GuiEventListener)new Button(buttonX, this.height / 2 - 59, 150, 20, this.getPowerString(this.be.isActive()), button -> {
            boolean toggledState = !this.be.isActive();
            boolean containsNotes = this.be.getNumberOfNotes() > 0;
            this.be.setActive(toggledState);
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new SyncSSSSettingsOnServer(this.be.getBlockPos(), toggledState ? SyncSSSSettingsOnServer.DataType.POWER_ON : SyncSSSSettingsOnServer.DataType.POWER_OFF), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.powerButton.setMessage(this.getPowerString(toggledState));
            if (!toggledState) {
                this.recordingButton.setMessage(this.getRecordingString(false));
            }
            this.recordingButton.active = toggledState;
            this.soundButton.active = toggledState;
            this.playButton.active = toggledState && containsNotes;
            this.clearButton.active = toggledState && containsNotes;
        }, Button.DEFAULT_NARRATION));
        this.recordingButton = (Button)this.addRenderableWidget((GuiEventListener)new Button(buttonX, this.height / 2 - 37, 150, 20, this.getRecordingString(this.be.isRecording()), button -> {
            boolean recording = !this.be.isRecording();
            this.be.setRecording(recording);
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new SyncSSSSettingsOnServer(this.be.getBlockPos(), recording ? SyncSSSSettingsOnServer.DataType.RECORDING_ON : SyncSSSSettingsOnServer.DataType.RECORDING_OFF), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.recordingButton.setMessage(this.getRecordingString(this.be.isRecording()));
        }, Button.DEFAULT_NARRATION));
        this.playButton = (Button)this.addRenderableWidget((GuiEventListener)new Button(buttonX, this.height / 2 - 15, 150, 20, (Component)Utils.localize("gui.securitycraft:sonic_security_system.recording.play", new Object[0]), button -> {
            if (this.be.getNumberOfNotes() > 0) {
                this.playback = true;
            }
        }, Button.DEFAULT_NARRATION));
        this.clearButton = (Button)this.addRenderableWidget((GuiEventListener)new Button(buttonX, this.height / 2 + 7, 150, 20, (Component)Utils.localize("gui.securitycraft:sonic_security_system.recording.clear", new Object[0]), button -> {
            this.be.clearNotes();
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new SyncSSSSettingsOnServer(this.be.getBlockPos(), SyncSSSSettingsOnServer.DataType.CLEAR_NOTES), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.playButton.active = false;
            this.clearButton.active = false;
        }, Button.DEFAULT_NARRATION));
        this.invertButton = (Button)this.addRenderableWidget((GuiEventListener)new Button(buttonX, this.height / 2 + 29, 150, 20, (Component)Utils.localize("gui.securitycraft:sonic_security_system.invert_functionality", new Object[0]), button -> {
            this.be.setDisableBlocksWhenTuneIsPlayed(!this.be.disablesBlocksWhenTuneIsPlayed());
            this.updateInvertButtonTooltip();
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new SyncSSSSettingsOnServer(this.be.getBlockPos(), SyncSSSSettingsOnServer.DataType.INVERT_FUNCTIONALITY), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }, Button.DEFAULT_NARRATION));
        this.updateInvertButtonTooltip();
        this.soundButton = (TogglePictureButton)this.addRenderableWidget((GuiEventListener)new TogglePictureButton(buttonX + 130, this.height / 2 + 52, 20, 20, 2, 16, 16, 2, button -> {
            boolean toggledPing = !this.be.pings();
            this.be.setPings(toggledPing);
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new SyncSSSSettingsOnServer(this.be.getBlockPos(), toggledPing ? SyncSSSSettingsOnServer.DataType.SOUND_ON : SyncSSSSettingsOnServer.DataType.SOUND_OFF), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }, SecurityCraft.resLoc("sonic_security_system/sound"), SecurityCraft.resLoc("sonic_security_system/no_sound")));
        this.soundButton.setCurrentIndex(!this.be.pings() ? 1 : 0);
        this.connectionList = (SSSConnectionList)this.addRenderableWidget((GuiEventListener)new SSSConnectionList<SonicSecuritySystemScreen>(this, this.minecraft, 130, 120, this.powerButton.getY(), this.leftPos + 10));
        this.powerButton.active = !this.be.isShutDown() && this.isOwner;
        this.recordingButton.active = isActive && this.isOwner;
        this.soundButton.active = isActive && this.isOwner;
        this.playButton.active = isActive && hasNotes;
        this.clearButton.active = isActive && hasNotes && this.isOwner;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int textWidth = this.font.width((FormattedText)this.title);
        int soundTextLength = this.font.width((FormattedText)SOUND_TEXT);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawString(this.font, this.title, this.leftPos + this.xSize / 2 - textWidth / 2, this.topPos + 6, -12566464, false);
        guiGraphics.drawString(this.font, SOUND_TEXT, this.soundButton.getX() - soundTextLength - 5, this.topPos + 141, -12566464, false);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.xSize, this.ySize, 512, 512);
    }

    public boolean keyPressed(KeyEvent event) {
        if (this.minecraft.options.keyInventory.isActiveAndMatches(InputConstants.getKey((KeyEvent)event))) {
            this.onClose();
            return true;
        }
        return super.keyPressed(event);
    }

    public boolean isPauseScreen() {
        return false;
    }

    @Override
    public List<GlobalPos> getPositions() {
        if (this.isOwner) {
            return this.be.getLinkedBlocks();
        }
        return List.of();
    }

    @Override
    public void removePosition(GlobalPos globalPos) {
        this.be.delink(globalPos, true);
        this.connectionList.refreshPositions();
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new SyncSSSSettingsOnServer(this.be.getBlockPos(), SyncSSSSettingsOnServer.DataType.REMOVE_POS, globalPos), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private Component getRecordingString(boolean recording) {
        return recording ? Utils.localize("gui.securitycraft:sonic_security_system.stop_recording", new Object[0]) : Utils.localize("gui.securitycraft:sonic_security_system.start_recording", new Object[0]);
    }

    private Component getPowerString(boolean on) {
        return on ? Utils.localize("gui.securitycraft:sonic_security_system.power.on", new Object[0]) : Utils.localize("gui.securitycraft:sonic_security_system.power.off", new Object[0]);
    }

    private void updateInvertButtonTooltip() {
        this.invertButton.setTooltip(Tooltip.create((Component)Utils.localize("gui.securitycraft:sonic_security_system.invert.tooltip_" + (this.be.disablesBlocksWhenTuneIsPlayed() ? "inverted" : "default"), new Object[0])));
    }
}

