/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.network.server.SetPasscode;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class SetPasscodeScreen
extends Screen {
    private static final ResourceLocation TEXTURE = SecurityCraft.resLoc("textures/gui/container/blank.png");
    private int imageWidth = 176;
    private int imageHeight = 166;
    private int leftPos;
    private int topPos;
    private IPasscodeProtected passcodeProtected;
    private Component setup;
    private MutableComponent combined;
    private EditBox keycodeTextbox;
    private Button saveAndContinueButton;

    public SetPasscodeScreen(IPasscodeProtected passcodeProtected, Component title) {
        super(title);
        this.passcodeProtected = passcodeProtected;
        this.setup = Utils.localize("gui.securitycraft:passcode.setup", new Object[0]);
        this.combined = title.plainCopy().append((Component)Component.literal((String)" ")).append(this.setup);
    }

    public void init() {
        super.init();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.saveAndContinueButton = (Button)this.addRenderableWidget((GuiEventListener)new Button(this.width / 2 - 48, this.height / 2 + 30 + 10, 100, 20, (Component)Utils.localize("gui.securitycraft:passcode.save", new Object[0]), this::saveAndContinueButtonClicked, Button.DEFAULT_NARRATION));
        this.saveAndContinueButton.active = false;
        this.keycodeTextbox = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.width / 2 - 37, this.height / 2 - 47, 77, 12, (Component)Component.empty()));
        this.keycodeTextbox.setMaxLength(Integer.MAX_VALUE);
        this.keycodeTextbox.setFilter(s -> s.matches("\\d*"));
        this.keycodeTextbox.setResponder(text -> {
            this.saveAndContinueButton.active = !text.isEmpty();
        });
        this.setInitialFocus((GuiEventListener)this.keycodeTextbox);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawString(this.font, "CODE:", this.width / 2 - 67, this.height / 2 - 47 + 2, -12566464);
        if (this.font.width((FormattedText)this.combined) < this.imageWidth - 10) {
            guiGraphics.drawString(this.font, (Component)this.combined, this.width / 2 - this.font.width((FormattedText)this.combined) / 2, this.topPos + 6, -12566464, false);
        } else {
            guiGraphics.drawString(this.font, this.title, this.width / 2 - this.font.width((FormattedText)this.title) / 2, this.topPos + 6, -12566464, false);
            guiGraphics.drawString(this.font, this.setup, this.width / 2 - this.font.width((FormattedText)this.setup) / 2, this.topPos + 16, -12566464, false);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    public boolean keyPressed(KeyEvent event) {
        if (this.minecraft.options.keyInventory.isActiveAndMatches(InputConstants.getKey((KeyEvent)event))) {
            this.onClose();
            return true;
        }
        if (event.key() == 335 || event.key() == 257 && this.saveAndContinueButton.active) {
            this.saveAndContinueButtonClicked(this.saveAndContinueButton);
        }
        return super.keyPressed(event);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void saveAndContinueButtonClicked(Button button) {
        IPasscodeProtected iPasscodeProtected = this.passcodeProtected;
        if (iPasscodeProtected instanceof BlockEntity) {
            BlockEntity be = (BlockEntity)iPasscodeProtected;
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new SetPasscode(be.getBlockPos(), this.keycodeTextbox.getValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            iPasscodeProtected = this.passcodeProtected;
            if (iPasscodeProtected instanceof Entity) {
                Entity entity = (Entity)iPasscodeProtected;
                ClientPacketDistributor.sendToServer((CustomPacketPayload)new SetPasscode(entity.getId(), this.keycodeTextbox.getValue()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        Minecraft.getInstance().player.closeContainer();
    }
}

