/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.blockentities.TrophySystemBlockEntity;
import net.geforcemods.securitycraft.renderers.state.TrophySystemRenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TrophySystemRenderer
implements BlockEntityRenderer<TrophySystemBlockEntity, TrophySystemRenderState> {
    public static final int RENDER_DISTANCE = 50;

    public TrophySystemRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void submit(TrophySystemRenderState state, PoseStack poseStack, SubmitNodeCollector collector, CameraRenderState camera) {
        ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.trySubmitDelegate(state.disguiseRenderState, poseStack, collector, camera);
        Vec3 target = state.target;
        if (target != null) {
            collector.submitCustomGeometry(poseStack, RenderType.lines(), (pose, builder) -> {
                BlockPos pos = state.blockPos;
                int r = state.r;
                int g = state.g;
                int b = state.b;
                builder.addVertex(pose, 0.5f, 0.75f, 0.5f).setColor(r, g, b, 255).setNormal(1.0f, 1.0f, 1.0f);
                builder.addVertex(pose, (float)(target.x() - (double)pos.getX()), (float)(target.y() - (double)pos.getY()), (float)(target.z() - (double)pos.getZ())).setColor(r, g, b, 255).setNormal(1.0f, 1.0f, 1.0f);
            });
        }
    }

    public TrophySystemRenderState createRenderState() {
        return new TrophySystemRenderState();
    }

    public void extractRenderState(TrophySystemBlockEntity be, TrophySystemRenderState state, float partialTick, Vec3 cameraPos, ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)be, (BlockEntityRenderState)state, partialTick, cameraPos, crumblingOverlay);
        state.disguiseRenderState = ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.tryExtractFromDelegate(be, partialTick, cameraPos, crumblingOverlay);
        Projectile target = be.getTarget();
        state.target = target == null ? null : target.position();
        ItemStack lens = be.getLensContainer().getItem(0);
        int r = 255;
        int g = 255;
        int b = 255;
        if (lens.has(DataComponents.DYED_COLOR)) {
            int color = ((DyedItemColor)lens.get(DataComponents.DYED_COLOR)).rgb();
            r = color >> 16 & 0xFF;
            g = color >> 8 & 0xFF;
            b = color & 0xFF;
        }
        state.r = r;
        state.g = g;
        state.b = b;
    }

    public boolean shouldRenderOffScreen() {
        return true;
    }

    public AABB getRenderBoundingBox(TrophySystemBlockEntity be) {
        return new AABB(be.getBlockPos()).inflate(50.0);
    }
}

