/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.models.SonicSecuritySystemModel;
import net.geforcemods.securitycraft.renderers.state.SonicSecuritySystemRenderState;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class SonicSecuritySystemRenderer
implements BlockEntityRenderer<SonicSecuritySystemBlockEntity, SonicSecuritySystemRenderState> {
    private static final Quaternionf POSITIVE_X_180 = Axis.XP.rotationDegrees(180.0f);
    private static final ResourceLocation TEXTURE = SecurityCraft.resLoc("textures/block/sonic_security_system.png");
    private static final Component RECORDING_TEXT = Utils.localize("gui.securitycraft:sonic_security_system.recording", new Object[0]);
    private static final Component LISTENING_TEXT = Utils.localize("gui.securitycraft:sonic_security_system.listening", new Object[0]);
    private final SonicSecuritySystemModel model;
    private final EntityRenderDispatcher entityRenderDispatcher;

    public SonicSecuritySystemRenderer(BlockEntityRendererProvider.Context ctx) {
        this.model = new SonicSecuritySystemModel(ctx.bakeLayer(ClientHandler.SONIC_SECURITY_SYSTEM_LOCATION));
        this.entityRenderDispatcher = ctx.entityRenderer();
    }

    public void submit(SonicSecuritySystemRenderState state, PoseStack pose, SubmitNodeCollector collector, CameraRenderState camera) {
        ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.trySubmitDelegate(state.disguiseRenderState, pose, collector, camera);
        pose.translate(0.5, 1.0, 0.5);
        if (state.isRecording || state.isListening && !state.isShutDown) {
            Component text = state.isRecording ? RECORDING_TEXT : LISTENING_TEXT;
            collector.submitNameTag(pose, Vec3.ZERO, 0, text, true, state.lightCoords, state.distanceToCameraSqr, camera);
        }
        if (!state.isDisguised) {
            pose.translate(0.0, 0.5, 0.0);
            pose.mulPose((Quaternionfc)POSITIVE_X_180);
            collector.submitModel((Model)this.model, (Object)Float.valueOf(state.radarRotation), pose, RenderType.entitySolid((ResourceLocation)TEXTURE), state.lightCoords, OverlayTexture.NO_OVERLAY, 0, state.breakProgress);
        }
    }

    public SonicSecuritySystemRenderState createRenderState() {
        return new SonicSecuritySystemRenderState();
    }

    public void extractRenderState(SonicSecuritySystemBlockEntity be, SonicSecuritySystemRenderState state, float partialTick, Vec3 cameraPos, ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)be, (BlockEntityRenderState)state, partialTick, cameraPos, crumblingOverlay);
        state.disguiseRenderState = ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.tryExtractFromDelegate(be, partialTick, cameraPos, crumblingOverlay);
        state.isRecording = be.isRecording();
        state.isListening = be.isListening();
        state.isShutDown = be.isShutDown();
        state.isDisguised = be.isModuleEnabled(ModuleType.DISGUISE);
        state.radarRotation = Mth.lerp((float)partialTick, (float)be.getOriginalRadarRotationDegrees(), (float)be.getRadarRotationDegrees());
        state.distanceToCameraSqr = cameraPos.distanceToSqr(Vec3.upFromBottomCenterOf((Vec3i)be.getBlockPos(), (double)1.5));
    }
}

