/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.geforcemods.securitycraft.models.SentryModel;
import net.geforcemods.securitycraft.renderers.state.SentryRenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.joml.Quaternionfc;

public class SentryRenderer
extends EntityRenderer<Sentry, SentryRenderState> {
    private static final ResourceLocation TEXTURE = SecurityCraft.resLoc("textures/entity/sentry.png");
    private final SentryModel model;

    public SentryRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.model = new SentryModel(ctx.bakeLayer(ClientHandler.SENTRY_LOCATION));
    }

    public void submit(SentryRenderState state, PoseStack pose, SubmitNodeCollector collector, CameraRenderState camera) {
        RenderType renderType = RenderType.entitySolid((ResourceLocation)TEXTURE);
        float scale = state.scale;
        pose.pushPose();
        pose.scale(scale, scale, scale);
        pose.translate(0.0, 1.5, 0.0);
        pose.scale(-1.0f, -1.0f, 1.0f);
        this.model.submitBase(state, pose, collector, renderType);
        pose.mulPose((Quaternionfc)Axis.YP.rotationDegrees(state.headRotation));
        pose.translate(0.0f, state.headY, 0.0f);
        this.model.submitHead(state, pose, collector, renderType);
        pose.popPose();
    }

    public SentryRenderState createRenderState() {
        return new SentryRenderState();
    }

    public void extractRenderState(Sentry sentry, SentryRenderState state, float partialTicks) {
        super.extractRenderState((Entity)sentry, (EntityRenderState)state, partialTicks);
        state.headRotation = Mth.lerp((float)partialTicks, (float)sentry.getOriginalHeadRotation(), (float)sentry.getHeadRotation());
        state.headY = sentry.getHeadYTranslation(partialTicks);
    }
}

