/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.entity.camera.FrameFeedHandler;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.models.SecurityCameraModel;
import net.geforcemods.securitycraft.renderers.state.SecurityCameraRenderState;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class SecurityCameraRenderer
implements BlockEntityRenderer<SecurityCameraBlockEntity, SecurityCameraRenderState> {
    private static final Quaternionf POSITIVE_Y_180 = Axis.YP.rotationDegrees(180.0f);
    private static final Quaternionf POSITIVE_Y_90 = Axis.YP.rotationDegrees(90.0f);
    private static final Quaternionf NEGATIVE_Y_90 = Axis.YN.rotationDegrees(90.0f);
    private static final Quaternionf POSITIVE_X_180 = Axis.XP.rotationDegrees(180.0f);
    private static final ResourceLocation TEXTURE = SecurityCraft.resLoc("textures/entity/security_camera/security_camera.png");
    private static final ResourceLocation BEING_VIEWED_TEXTURE = SecurityCraft.resLoc("textures/entity/security_camera/security_camera_viewing.png");
    private final SecurityCameraModel model;

    public SecurityCameraRenderer(BlockEntityRendererProvider.Context ctx) {
        this.model = new SecurityCameraModel(ctx.bakeLayer(ClientHandler.SECURITY_CAMERA_LOCATION));
    }

    public void submit(SecurityCameraRenderState state, PoseStack pose, SubmitNodeCollector collector, CameraRenderState camera) {
        if (state.isBeingCaptured || state.isBeingViewed) {
            return;
        }
        ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.trySubmitDelegate(state.disguiseRenderState, pose, collector, camera);
        if (state.isDown) {
            return;
        }
        if (!state.isDisguised) {
            Direction side = state.direction;
            pose.translate(0.5, 1.5, 0.5);
            if (side == Direction.NORTH) {
                pose.mulPose((Quaternionfc)POSITIVE_Y_180);
            } else if (side == Direction.EAST) {
                pose.mulPose((Quaternionfc)POSITIVE_Y_90);
            } else if (side == Direction.WEST) {
                pose.mulPose((Quaternionfc)NEGATIVE_Y_90);
            }
            pose.mulPose((Quaternionfc)POSITIVE_X_180);
            collector.submitModel((Model)this.model, (Object)state, pose, RenderType.entitySolid((ResourceLocation)state.texture), state.lightCoords, OverlayTexture.NO_OVERLAY, state.lensColor, null, 0, state.breakProgress);
        }
    }

    public SecurityCameraRenderState createRenderState() {
        return new SecurityCameraRenderState();
    }

    public void extractRenderState(SecurityCameraBlockEntity be, SecurityCameraRenderState state, float partialTick, Vec3 cameraPos, ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)be, (BlockEntityRenderState)state, partialTick, cameraPos, crumblingOverlay);
        state.disguiseRenderState = ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.tryExtractFromDelegate(be, partialTick, cameraPos, crumblingOverlay);
        state.isBeingCaptured = FrameFeedHandler.amIBeingCaptured(be);
        state.isBeingViewed = PlayerUtils.isPlayerMountedOnCamera((LivingEntity)Minecraft.getInstance().player) && Minecraft.getInstance().getCameraEntity().blockPosition().equals((Object)be.getBlockPos());
        state.isDown = be.isDown();
        state.isDisguised = be.isModuleEnabled(ModuleType.DISGUISE);
        state.direction = (Direction)be.getBlockState().getValue(SecurityCameraBlock.FACING);
        state.isShutDown = be.isShutDown();
        state.cameraYRot = (float)Mth.lerp((double)partialTick, (double)be.getOriginalCameraRotation(), (double)be.getCameraRotation());
        ItemStack lens = be.getLensContainer().getItem(0);
        float r = 0.4392157f;
        float g = 1.0f;
        float b = 1.0f;
        if (lens.has(DataComponents.DYED_COLOR)) {
            int color = ((DyedItemColor)lens.get(DataComponents.DYED_COLOR)).rgb();
            r = ARGB.redFloat((int)color);
            g = ARGB.greenFloat((int)color);
            b = ARGB.blueFloat((int)color);
            state.hasLens = true;
        } else {
            state.hasLens = false;
        }
        state.lensColor = ARGB.colorFromFloat((float)1.0f, (float)r, (float)g, (float)b);
        state.texture = (Boolean)be.getBlockState().getValue((Property)SecurityCameraBlock.BEING_VIEWED) != false ? BEING_VIEWED_TEXTURE : TEXTURE;
    }
}

