/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.blockentities.RetinalScannerBlockEntity;
import net.geforcemods.securitycraft.blocks.RetinalScannerBlock;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.renderers.state.RetinalScannerRenderState;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.PlayerSkinRenderCache;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class RetinalScannerRenderer
implements BlockEntityRenderer<RetinalScannerBlockEntity, RetinalScannerRenderState> {
    private static final float CORRECT_FACTOR = 0.0018181818f;
    private final PlayerSkinRenderCache playerSkinRenderCache;

    public RetinalScannerRenderer(BlockEntityRendererProvider.Context ctx) {
        this.playerSkinRenderCache = ctx.playerSkinRenderCache();
    }

    public void submit(RetinalScannerRenderState state, PoseStack poseStack, SubmitNodeCollector collector, CameraRenderState camera) {
        if (ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.trySubmitDelegate(state.disguiseRenderState, poseStack, collector, camera)) {
            return;
        }
        Direction direction = state.direction;
        if (direction != null) {
            if (state.isDisguised) {
                return;
            }
            poseStack.pushPose();
            switch (direction) {
                case NORTH: {
                    poseStack.translate(0.25f, 0.0625f, 0.0f);
                    break;
                }
                case SOUTH: {
                    poseStack.translate(0.75f, 0.0625f, 1.0f);
                    poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
                    break;
                }
                case WEST: {
                    poseStack.translate(0.0f, 0.0625f, 0.75f);
                    poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
                    break;
                }
                case EAST: {
                    poseStack.translate(1.0f, 0.0625f, 0.25f);
                    poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(270.0f));
                    break;
                }
            }
            poseStack.scale(-1.0f, -1.0f, 1.0f);
            collector.submitCustomGeometry(poseStack, state.renderType, (pose, builder) -> {
                Vec3i normalVector = direction.getUnitVec3i();
                int combinedLight = state.combinedSkinLight;
                builder.addVertex(pose, 0.0018181818f, 0.0027272727f, 0.0f).setColor(255, 255, 255, 255).setUv(0.125f, 0.25f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(combinedLight).setNormal(pose, (float)normalVector.getX(), (float)normalVector.getY(), (float)normalVector.getZ());
                builder.addVertex(pose, 0.0018181818f, -0.5009091f, 0.0f).setColor(255, 255, 255, 255).setUv(0.125f, 0.125f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(combinedLight).setNormal(pose, (float)normalVector.getX(), (float)normalVector.getY(), (float)normalVector.getZ());
                builder.addVertex(pose, -0.5018182f, -0.5009091f, 0.0f).setColor(255, 255, 255, 255).setUv(0.25f, 0.125f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(combinedLight).setNormal(pose, (float)normalVector.getX(), (float)normalVector.getY(), (float)normalVector.getZ());
                builder.addVertex(pose, -0.5018182f, 0.0027272727f, 0.0f).setColor(255, 255, 255, 255).setUv(0.25f, 0.25f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(combinedLight).setNormal(pose, (float)normalVector.getX(), (float)normalVector.getY(), (float)normalVector.getZ());
                builder.addVertex(pose, 0.0018181818f, 0.0027272727f, 0.0f).setColor(255, 255, 255, 255).setUv(0.625f, 0.25f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(combinedLight).setNormal(pose, (float)normalVector.getX(), (float)normalVector.getY(), (float)normalVector.getZ());
                builder.addVertex(pose, 0.0018181818f, -0.5009091f, 0.0f).setColor(255, 255, 255, 255).setUv(0.625f, 0.125f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(combinedLight).setNormal(pose, (float)normalVector.getX(), (float)normalVector.getY(), (float)normalVector.getZ());
                builder.addVertex(pose, -0.5018182f, -0.5009091f, 0.0f).setColor(255, 255, 255, 255).setUv(0.75f, 0.125f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(combinedLight).setNormal(pose, (float)normalVector.getX(), (float)normalVector.getY(), (float)normalVector.getZ());
                builder.addVertex(pose, -0.5018182f, 0.0027272727f, 0.0f).setColor(255, 255, 255, 255).setUv(0.75f, 0.25f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(combinedLight).setNormal(pose, (float)normalVector.getX(), (float)normalVector.getY(), (float)normalVector.getZ());
            });
            poseStack.popPose();
        }
    }

    public RetinalScannerRenderState createRenderState() {
        return new RetinalScannerRenderState();
    }

    public void extractRenderState(RetinalScannerBlockEntity be, RetinalScannerRenderState state, float partialTick, Vec3 cameraPos, ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)be, (BlockEntityRenderState)state, partialTick, cameraPos, crumblingOverlay);
        Direction direction = (Direction)be.getBlockState().getValue(RetinalScannerBlock.FACING);
        BlockPos offsetPos = be.getBlockPos().relative(direction);
        state.disguiseRenderState = ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.tryExtractFromDelegate(be, partialTick, cameraPos, crumblingOverlay);
        state.renderType = this.getRenderType(be.getPlayerProfile());
        state.direction = direction;
        state.isDisguised = be.isModuleEnabled(ModuleType.DISGUISE) && ModuleItem.getBlockAddon(be.getModule(ModuleType.DISGUISE)) != null;
        state.combinedSkinLight = LightTexture.pack((int)be.getLevel().getBrightness(LightLayer.BLOCK, offsetPos), (int)be.getLevel().getBrightness(LightLayer.SKY, offsetPos));
    }

    private RenderType getRenderType(ResolvableProfile profile) {
        if (((Boolean)ConfigHandler.SERVER.retinalScannerFace.get()).booleanValue() && profile != null) {
            return this.playerSkinRenderCache.getOrDefault(profile).renderType();
        }
        return RenderType.entityCutout((ResourceLocation)DefaultPlayerSkin.getDefaultTexture());
    }
}

