/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.HashCommon;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.DisplayCaseBlockEntity;
import net.geforcemods.securitycraft.blocks.DisplayCaseBlock;
import net.geforcemods.securitycraft.models.DisplayCaseModel;
import net.geforcemods.securitycraft.renderers.state.DisplayCaseRenderState;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class DisplayCaseRenderer
implements BlockEntityRenderer<DisplayCaseBlockEntity, DisplayCaseRenderState> {
    private final ResourceLocation texture = SecurityCraft.resLoc("textures/entity/display_case/normal.png");
    private final ResourceLocation glowTexture = SecurityCraft.resLoc("textures/entity/display_case/glow.png");
    private final DisplayCaseModel model;
    private final ItemModelResolver itemModelResolver;
    private final boolean glowing;

    public DisplayCaseRenderer(BlockEntityRendererProvider.Context ctx, boolean glowing) {
        this.itemModelResolver = ctx.itemModelResolver();
        this.model = new DisplayCaseModel(ctx.bakeLayer(ClientHandler.DISPLAY_CASE_LOCATION));
        this.glowing = glowing;
    }

    public void submit(DisplayCaseRenderState state, PoseStack pose, SubmitNodeCollector collector, CameraRenderState camera) {
        float rotation = state.rotation;
        pose.pushPose();
        pose.translate(0.5, 0.5, 0.5);
        if (!state.stack.isEmpty()) {
            double insertionAmount = 0.40625;
            pose.pushPose();
            switch (state.attachFace) {
                case CEILING: {
                    pose.translate(0.0, insertionAmount, 0.0);
                    pose.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-rotation + 180.0f));
                    pose.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-90.0f));
                    break;
                }
                case FLOOR: {
                    pose.translate(0.0, -insertionAmount, 0.0);
                    pose.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-rotation + 180.0f));
                    pose.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
                    break;
                }
                case WALL: {
                    pose.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
                    pose.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-rotation));
                    pose.translate(0.0, 0.0, insertionAmount);
                }
            }
            int lightCoords = state.isGlowing ? 0xF000F0 : state.lightCoords;
            pose.scale(0.5f, 0.5f, 0.5f);
            state.stack.submit(pose, collector, lightCoords, OverlayTexture.NO_OVERLAY, 0);
            pose.popPose();
        }
        pose.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-rotation));
        switch (state.attachFace) {
            case CEILING: {
                pose.translate(0.0, 0.0, 1.0);
                pose.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-90.0f));
                break;
            }
            case FLOOR: {
                pose.translate(0.0, 0.0, -1.0);
                pose.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
                break;
            }
            case WALL: {
                pose.translate(0.0, 1.0, 0.0);
                pose.mulPose((Quaternionfc)Axis.XP.rotationDegrees(180.0f));
            }
        }
        RenderType renderType = RenderType.entityCutout((ResourceLocation)(state.isGlowing ? this.glowTexture : this.texture));
        pose.scale(-1.0f, 1.0f, -1.0f);
        collector.submitModel((Model)this.model, (Object)Float.valueOf(state.openness), pose, renderType, state.lightCoords, OverlayTexture.NO_OVERLAY, 0, state.breakProgress);
        pose.popPose();
    }

    public DisplayCaseRenderState createRenderState() {
        return new DisplayCaseRenderState();
    }

    public void extractRenderState(DisplayCaseBlockEntity be, DisplayCaseRenderState renderState, float partialTick, Vec3 cameraPos, ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)be, (BlockEntityRenderState)renderState, partialTick, cameraPos, crumblingOverlay);
        BlockState state = be.getBlockState();
        Direction facing = (Direction)state.getValue(DisplayCaseBlock.FACING);
        renderState.isGlowing = this.glowing;
        renderState.openness = be.getOpenness(partialTick);
        renderState.rotation = facing.toYRot();
        renderState.attachFace = (AttachFace)state.getValue(DisplayCaseBlock.ATTACH_FACE);
        this.itemModelResolver.updateForTopItem(renderState.stack, be.getDisplayedStack(), ItemDisplayContext.FIXED, be.getLevel(), null, HashCommon.long2int((long)be.getBlockPos().asLong()));
    }
}

