/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.geforcemods.securitycraft.blockentities.BlockPocketManagerBlockEntity;
import net.geforcemods.securitycraft.blocks.BlockPocketManagerBlock;
import net.geforcemods.securitycraft.renderers.state.BlockPocketManagerRenderState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShapeRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.Direction;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BlockPocketManagerRenderer
implements BlockEntityRenderer<BlockPocketManagerBlockEntity, BlockPocketManagerRenderState> {
    public static final int RENDER_DISTANCE = 100;

    public BlockPocketManagerRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void submit(BlockPocketManagerRenderState state, PoseStack poseStack, SubmitNodeCollector collector, CameraRenderState camera) {
        if (!state.showsOutline || !state.ownedByPlayer) {
            return;
        }
        collector.submitCustomGeometry(poseStack, RenderType.lines(), (pose, builder) -> ShapeRenderer.renderLineBox((PoseStack.Pose)pose, (VertexConsumer)builder, (double)state.leftX, (double)0.0, (double)state.frontZ, (double)state.rightX, (double)state.size, (double)state.backZ, (float)state.r, (float)state.g, (float)state.b, (float)1.0f));
    }

    public BlockPocketManagerRenderState createRenderState() {
        return new BlockPocketManagerRenderState();
    }

    public void extractRenderState(BlockPocketManagerBlockEntity be, BlockPocketManagerRenderState state, float partialTick, Vec3 cameraPos, ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)be, (BlockEntityRenderState)state, partialTick, cameraPos, crumblingOverlay);
        Direction facing = (Direction)be.getBlockState().getValue(BlockPocketManagerBlock.FACING);
        int offset = facing == Direction.NORTH || facing == Direction.EAST ? -be.getAutoBuildOffset() : be.getAutoBuildOffset();
        int size = be.getSize();
        int half = (size - 1) / 2;
        int leftX = -half + offset;
        int rightX = half + 1 + offset;
        int frontZ = facing == Direction.NORTH || facing == Direction.WEST ? 0 : 1;
        int backZ = facing == Direction.NORTH || facing == Direction.WEST ? size : 1 - size;
        int packedColor = be.getColor();
        if (facing == Direction.EAST || facing == Direction.WEST) {
            leftX = frontZ;
            rightX = backZ;
            frontZ = -half + offset;
            backZ = half + 1 + offset;
        }
        state.showsOutline = be.showsOutline();
        state.ownedByPlayer = be.isOwnedBy((Entity)Minecraft.getInstance().player);
        state.size = size;
        state.leftX = leftX;
        state.rightX = rightX;
        state.frontZ = frontZ;
        state.backZ = backZ;
        state.r = ARGB.redFloat((int)packedColor);
        state.g = ARGB.greenFloat((int)packedColor);
        state.b = ARGB.blueFloat((int)packedColor);
    }

    public boolean shouldRenderOffScreen() {
        return true;
    }

    public AABB getRenderBoundingBox(BlockPocketManagerBlockEntity be) {
        return new AABB(be.getBlockPos()).inflate(100.0);
    }
}

