/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.mixin.suspiciousmines;

import com.llamalad7.mixinextras.sugar.Local;
import java.util.function.Predicate;
import net.geforcemods.securitycraft.SCTags;
import net.geforcemods.securitycraft.blockentities.BrushableMineBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BrushItem.class})
public class BrushItemMixin {
    @Inject(method={"calculateHitResult"}, at={@At(value="HEAD")}, cancellable=true)
    private void securitycraft$makeSuspiciousMinesBrushablePartTwo(Player player, CallbackInfoReturnable<HitResult> cir) {
        EntityHitResult hitResult1;
        Vec3 direction;
        Vec3 eyePosition = player.getEyePosition();
        Predicate<Entity> entitySelector = e -> {
            LivingEntity livingEntity;
            return (e instanceof LivingEntity ? (livingEntity = (LivingEntity)e).canBeSeenByAnyone() : !e.isSpectator()) && e.isPickable();
        };
        Vec3 viewVector = player.getViewVector(0.0f).scale(player.blockInteractionRange());
        Level level = player.level();
        BlockHitResult hitResult = level.clip(new ClipContext(eyePosition, direction = eyePosition.add(viewVector), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        if (hitResult.getType() != HitResult.Type.MISS) {
            direction = hitResult.getLocation();
        }
        if ((hitResult1 = ProjectileUtil.getEntityHitResult((Level)level, (Entity)player, (Vec3)eyePosition, (Vec3)direction, (AABB)player.getBoundingBox().expandTowards(viewVector).inflate(1.0), entitySelector, (float)0.0f)) != null) {
            hitResult = hitResult1;
        }
        if (hitResult.getType() == HitResult.Type.BLOCK && level.getBlockState(BlockPos.containing((Position)hitResult.getLocation())).is(SCTags.Blocks.SUSPICIOUS_MINES)) {
            cir.setReturnValue((Object)hitResult);
        }
    }

    @Inject(method={"onUseTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getBlockEntity(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/entity/BlockEntity;")}, cancellable=true)
    private void securitycraft$checkForSuspiciousMine(Level level, LivingEntity entity, ItemStack stack, int tick, CallbackInfo ci, @Local Player player, @Local BlockHitResult blockHitResult, @Local BlockPos pos, @Local BlockState brushedState) {
        BlockEntity blockEntity;
        if (!level.isClientSide() && brushedState.is(SCTags.Blocks.SUSPICIOUS_MINES) && (blockEntity = level.getBlockEntity(pos)) instanceof BrushableMineBlockEntity) {
            BrushableMineBlockEntity be = (BrushableMineBlockEntity)blockEntity;
            boolean brushFinished = be.brush(level.getGameTime(), (ServerLevel)level, (LivingEntity)player, blockHitResult.getDirection(), stack);
            if (brushFinished) {
                stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            }
            ci.cancel();
        }
    }
}

