/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.mixin.camera;

import com.llamalad7.mixinextras.sugar.Local;
import java.util.HashSet;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.misc.BlockEntityTracker;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkTrackingView;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkMap.class}, priority=1100)
public abstract class ChunkMapMixin {
    @Shadow
    protected abstract void markChunkPendingToSend(ServerPlayer var1, ChunkPos var2);

    @Shadow
    private static void markChunkPendingToSend(ServerPlayer player, LevelChunk chunk) {
    }

    @Shadow
    private static void dropChunk(ServerPlayer player, ChunkPos chunkPos) {
    }

    @Shadow
    abstract int getPlayerViewDistance(ServerPlayer var1);

    @Inject(method={"updateChunkTracking"}, at={@At(value="HEAD")})
    private void securitycraft$onUpdateChunkTracking(ServerPlayer player, CallbackInfo ci) {
        Object camera;
        ServerLevel level = player.level();
        int viewDistance = this.getPlayerViewDistance(player);
        Entity entity = player.getCamera();
        if (entity instanceof SecurityCamera && !((SecurityCamera)((Object)(camera = (SecurityCamera)entity))).hasSentChunks()) {
            ChunkTrackingView.difference((ChunkTrackingView)player.getChunkTrackingView(), (ChunkTrackingView)((SecurityCamera)((Object)camera)).getCameraChunks(), chunkPos -> this.markChunkPendingToSend(player, (ChunkPos)chunkPos), chunkPos -> {});
            ((SecurityCamera)((Object)camera)).setHasSentChunks(true);
        }
        for (SecurityCameraBlockEntity viewedCamera : BlockEntityTracker.FRAME_VIEWED_SECURITY_CAMERAS.getBlockEntitiesWithCondition((Level)level, be -> be.shouldSendChunksToPlayer(player))) {
            ChunkTrackingView.difference((ChunkTrackingView)player.getChunkTrackingView(), (ChunkTrackingView)viewedCamera.getCameraFeedChunks(player), chunkPos -> this.markChunkPendingToSend(player, (ChunkPos)chunkPos), chunkPos -> {});
        }
        HashSet<Object> unviewedChunkViews = new HashSet<Object>();
        if (SecurityCameraBlockEntity.hasRecentlyUnviewedCameras(player)) {
            for (SecurityCameraBlockEntity securityCameraBlockEntity : SecurityCameraBlockEntity.fetchRecentlyUnviewedCameras(player)) {
                ChunkTrackingView.Positioned unviewedChunks = securityCameraBlockEntity.getCameraFeedChunks(player);
                if (unviewedChunks == null) continue;
                unviewedChunkViews.add(unviewedChunks);
                securityCameraBlockEntity.clearCameraFeedChunks(player);
            }
        }
        if (SecurityCamera.hasRecentlyDismounted(player)) {
            unviewedChunkViews.add(ChunkTrackingView.of((ChunkPos)new ChunkPos(SecurityCamera.fetchRecentDismountLocation(player)), (int)viewDistance));
        }
        for (ChunkTrackingView chunkTrackingView : unviewedChunkViews) {
            HashSet droppingChunks = new HashSet();
            ChunkTrackingView.difference((ChunkTrackingView)chunkTrackingView, (ChunkTrackingView)player.getChunkTrackingView(), chunkPos -> {}, droppingChunks::add);
            for (ChunkPos pos : droppingChunks) {
                if (!BlockEntityTracker.FRAME_VIEWED_SECURITY_CAMERAS.getBlockEntitiesWithCondition((Level)level, be -> be.shouldKeepChunkTracked(player, pos.x, pos.z)).isEmpty()) continue;
                ChunkMapMixin.dropChunk(player, pos);
            }
        }
    }

    @Inject(method={"onChunkReadyToSend"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerPlayer;getChunkTrackingView()Lnet/minecraft/server/level/ChunkTrackingView;")})
    private void securitycraft$sendChunksToCameras(ChunkHolder holder, LevelChunk chunk, CallbackInfo ci, @Local ServerPlayer player) {
        SecurityCamera camera2;
        ChunkPos pos = chunk.getPos();
        Entity entity = player.getCamera();
        if (entity instanceof SecurityCamera && (camera2 = (SecurityCamera)entity).getCameraChunks().contains(pos) || !BlockEntityTracker.FRAME_VIEWED_SECURITY_CAMERAS.getBlockEntitiesWithCondition((Level)player.level(), camera -> camera.shouldKeepChunkTracked(player, pos.x, pos.z)).isEmpty()) {
            ChunkMapMixin.markChunkPendingToSend(player, chunk);
        }
    }

    @Inject(method={"isChunkTracked"}, at={@At(value="HEAD")}, cancellable=true)
    private void securitycraft$onIsChunkTracked(ServerPlayer player, int x, int z, CallbackInfoReturnable<Boolean> cir) {
        SecurityCamera camera2;
        Entity entity = player.getCamera();
        if ((entity instanceof SecurityCamera && (camera2 = (SecurityCamera)entity).getCameraChunks().contains(x, z) || !BlockEntityTracker.FRAME_VIEWED_SECURITY_CAMERAS.getBlockEntitiesWithCondition((Level)player.level(), camera -> camera.shouldKeepChunkTracked(player, x, z)).isEmpty()) && !player.connection.chunkSender.isPending(ChunkPos.asLong((int)x, (int)z))) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"dropChunk"}, at={@At(value="HEAD")}, cancellable=true)
    private static void securitycraft$onDropChunk(ServerPlayer player, ChunkPos pos, CallbackInfo ci) {
        if (!BlockEntityTracker.FRAME_VIEWED_SECURITY_CAMERAS.getBlockEntitiesWithCondition((Level)player.level(), be -> be.shouldKeepChunkTracked(player, pos.x, pos.z)).isEmpty()) {
            ci.cancel();
        }
    }
}

