/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedHopperBlock;
import net.geforcemods.securitycraft.misc.PageGroup;
import net.geforcemods.securitycraft.misc.SCManualPage;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.level.Level;

public class SCManualItem
extends Item {
    public static final List<SCManualPage> PAGES = new ArrayList<SCManualPage>();
    public static int lastOpenPage = -1;

    public SCManualItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        if (level.isClientSide()) {
            ClientHandler.displaySCManualScreen();
        }
        return InteractionResult.CONSUME;
    }

    public static Optional<List<RecipeDisplay>> findRecipes(MinecraftServer server, Item item, PageGroup pageGroup) {
        RegistryAccess.Frozen registryAccess = server.registryAccess();
        CraftingInput dummyInput = CraftingInput.of((int)3, (int)3, (List)NonNullList.withSize((int)9, (Object)ItemStack.EMPTY));
        if (pageGroup == PageGroup.REINFORCED || item == ((ReinforcedHopperBlock)SCContent.REINFORCED_HOPPER.get()).asItem()) {
            return Optional.empty();
        }
        if (pageGroup == PageGroup.NONE) {
            for (RecipeHolder recipeHolder : server.getRecipeManager().getRecipes()) {
                ShapelessRecipe shapelessRecipe;
                Recipe resultItem;
                Recipe recipe = recipeHolder.value();
                if (recipe instanceof ShapedRecipe) {
                    ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
                    resultItem = SCManualItem.safeAssemble((CraftingRecipe)shapedRecipe, dummyInput, (HolderLookup.Provider)registryAccess);
                    if (!resultItem.is(item) || resultItem.is((Item)SCContent.LENS.get()) && resultItem.has(DataComponents.DYED_COLOR)) continue;
                    return Optional.of(shapedRecipe.display());
                }
                resultItem = recipeHolder.value();
                if (!(resultItem instanceof ShapelessRecipe) || !SCManualItem.safeAssemble((CraftingRecipe)(shapelessRecipe = (ShapelessRecipe)resultItem), dummyInput, (HolderLookup.Provider)registryAccess).is(item) || recipeHolder.id().location().getPath().endsWith("_reset")) continue;
                return Optional.of(shapelessRecipe.display());
            }
        } else if (pageGroup.hasRecipeGrid()) {
            ArrayList displays = new ArrayList();
            List<Item> pageItems = pageGroup.getItems().stream().map(ItemStack::getItem).toList();
            int stacksLeft = pageItems.size();
            for (RecipeHolder recipeHolder : server.getRecipeManager().getRecipes()) {
                ShapelessRecipe shapelessRecipe;
                Recipe resultItem;
                if (stacksLeft == 0) break;
                Recipe recipe = recipeHolder.value();
                if (recipe instanceof ShapedRecipe) {
                    ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
                    resultItem = SCManualItem.safeAssemble((CraftingRecipe)shapedRecipe, dummyInput, (HolderLookup.Provider)registryAccess);
                    if (resultItem.isEmpty() || !pageItems.contains(resultItem.getItem())) continue;
                    displays.addAll(shapedRecipe.display());
                    --stacksLeft;
                    continue;
                }
                resultItem = recipeHolder.value();
                if (!(resultItem instanceof ShapelessRecipe) || (resultItem = SCManualItem.safeAssemble((CraftingRecipe)(shapelessRecipe = (ShapelessRecipe)resultItem), dummyInput, (HolderLookup.Provider)registryAccess)).isEmpty() || !pageItems.contains(resultItem.getItem()) || recipeHolder.id().location().getPath().endsWith("_reset")) continue;
                displays.addAll(shapelessRecipe.display());
                --stacksLeft;
            }
            if (!displays.isEmpty()) {
                return Optional.of(displays);
            }
        }
        return Optional.empty();
    }

    private static ItemStack safeAssemble(CraftingRecipe recipe, CraftingInput dummyInput, HolderLookup.Provider registryAccess) {
        try {
            return recipe.assemble((RecipeInput)dummyInput, registryAccess);
        }
        catch (Exception exception) {
            return ItemStack.EMPTY;
        }
    }
}

