/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blocks.reinforced.ReinforcedScaffoldingBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ScaffoldingBlockItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ReinforcedScaffoldingBlockItem
extends ScaffoldingBlockItem {
    public ReinforcedScaffoldingBlockItem(Item.Properties properties) {
        super((Block)SCContent.REINFORCED_SCAFFOLDING.get(), properties);
    }

    public BlockPlaceContext updatePlacementContext(BlockPlaceContext ctx) {
        IOwnable scaffolding;
        Block block;
        BlockPos pos = ctx.getClickedPos();
        Level level = ctx.getLevel();
        BlockState state = level.getBlockState(pos);
        if (!state.is(block = this.getBlock())) {
            return ReinforcedScaffoldingBlock.getDistance((BlockGetter)level, pos) == 7 ? null : ctx;
        }
        Player player = ctx.getPlayer();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IOwnable && !(scaffolding = (IOwnable)blockEntity).isOwnedBy((Entity)player)) {
            return ctx;
        }
        int distance = 0;
        int maxBuildHeight = level.getMaxY();
        Direction direction = ctx.isSecondaryUseActive() ? (ctx.isInside() ? ctx.getClickedFace().getOpposite() : ctx.getClickedFace()) : (ctx.getClickedFace() == Direction.UP ? ctx.getHorizontalDirection() : Direction.UP);
        BlockPos.MutableBlockPos mutable = pos.mutable().move(direction);
        while (distance < 7) {
            if (!level.isClientSide() && !level.isInWorldBounds((BlockPos)mutable)) {
                if (!(player instanceof ServerPlayer)) break;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (mutable.getY() < maxBuildHeight) break;
                serverPlayer.sendSystemMessage((Component)Component.translatable((String)"build.tooHigh", (Object[])new Object[]{maxBuildHeight - 1}).withStyle(ChatFormatting.RED), true);
                break;
            }
            state = level.getBlockState((BlockPos)mutable);
            if (!state.is(block)) {
                if (!state.canBeReplaced(ctx)) break;
                return BlockPlaceContext.at((BlockPlaceContext)ctx, (BlockPos)mutable, (Direction)direction);
            }
            mutable.move(direction);
            if (!direction.getAxis().isHorizontal()) continue;
            ++distance;
        }
        return null;
    }
}

