/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.inventory;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blockentities.ProjectorBlockEntity;
import net.geforcemods.securitycraft.inventory.StateSelectorAccessMenu;
import net.geforcemods.securitycraft.network.server.SyncProjector;
import net.geforcemods.securitycraft.util.StandingOrWallType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class ProjectorMenu
extends StateSelectorAccessMenu {
    public static final int SIZE = 1;
    public final ProjectorBlockEntity be;
    private ContainerLevelAccess worldPosCallable;
    private Slot projectedBlockSlot;

    public ProjectorMenu(int windowId, Level level, BlockPos pos, Inventory inventory) {
        super((MenuType)SCContent.PROJECTOR_MENU.get(), windowId);
        this.be = (ProjectorBlockEntity)level.getBlockEntity(pos);
        this.worldPosCallable = ContainerLevelAccess.create((Level)level, (BlockPos)pos);
        this.projectedBlockSlot = this.addSlot(new Slot(this, this.be, 36, 80, 23){

            public boolean mayPlace(ItemStack stack) {
                return stack.getItem() instanceof BlockItem;
            }
        });
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)inventory, x + y * 9 + 9, 8 + x * 18, 84 + y * 18 + 69));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)inventory, x, 8 + x * 18, 211));
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack slotStackCopy = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            slotStackCopy = slotStack.copy();
            if (index < 1) {
                if (!this.moveItemStackTo(slotStack, 1, 37, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, slotStackCopy);
            } else if (!this.moveItemStackTo(slotStack, 0, 1, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == slotStackCopy.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotStack);
            this.broadcastChanges();
        }
        return slotStackCopy;
    }

    @Override
    public void onStateChange(BlockState state) {
        this.be.setProjectedState(state);
        this.broadcastChanges();
        if (this.be.getLevel().isClientSide()) {
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new SyncProjector(this.be.getBlockPos(), state), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public boolean stillValid(Player player) {
        return ProjectorMenu.stillValid((ContainerLevelAccess)this.worldPosCallable, (Player)player, (Block)((Block)SCContent.PROJECTOR.get()));
    }

    @Override
    public ItemStack getStateStack() {
        return this.projectedBlockSlot.getItem();
    }

    @Override
    public BlockState getSavedState() {
        return this.be.getProjectedState();
    }

    @Override
    public StandingOrWallType getStandingOrWallType() {
        return this.be.getStandingOrWallType();
    }
}

