/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.inventory;

import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.LinkableBlockEntity;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ModuleContainer
extends SimpleContainer {
    private final IModuleInventory moduleInventory;

    public ModuleContainer(IModuleInventory moduleInventory) {
        super(moduleInventory.getMaxNumberOfModules());
        this.items = moduleInventory.getInventory();
        this.moduleInventory = moduleInventory;
    }

    public ItemStack removeItem(int index, int count) {
        Item item;
        ItemStack removed = super.removeItem(index, count);
        if (!removed.isEmpty() && (item = removed.getItem()) instanceof ModuleItem) {
            ModuleItem module = (ModuleItem)item;
            this.moduleInventory.onModuleRemoved(removed, module.getModuleType(), false);
            IModuleInventory iModuleInventory = this.moduleInventory;
            if (iModuleInventory instanceof LinkableBlockEntity) {
                LinkableBlockEntity be = (LinkableBlockEntity)iModuleInventory;
                be.propagate((ILinkedAction)new ILinkedAction.ModuleRemoved(module.getModuleType(), false), be);
            }
        }
        return removed;
    }

    public ItemStack removeItemNoUpdate(int index) {
        Item item;
        ItemStack removed = super.removeItemNoUpdate(index);
        if (!removed.isEmpty() && (item = removed.getItem()) instanceof ModuleItem) {
            ModuleItem module = (ModuleItem)item;
            this.moduleInventory.onModuleRemoved(removed, module.getModuleType(), false);
            IModuleInventory iModuleInventory = this.moduleInventory;
            if (iModuleInventory instanceof LinkableBlockEntity) {
                LinkableBlockEntity be = (LinkableBlockEntity)iModuleInventory;
                be.propagate((ILinkedAction)new ILinkedAction.ModuleRemoved(module.getModuleType(), false), be);
            }
        }
        return removed;
    }

    public void setItem(int index, ItemStack stack) {
        Object be;
        IModuleInventory iModuleInventory;
        ModuleItem module;
        Item item;
        ItemStack previous = this.getItem(index);
        super.setItem(index, stack);
        if (ItemStack.matches((ItemStack)previous, (ItemStack)stack)) {
            return;
        }
        if (!previous.isEmpty() && (item = previous.getItem()) instanceof ModuleItem) {
            module = (ModuleItem)item;
            this.moduleInventory.onModuleRemoved(previous, module.getModuleType(), false);
            iModuleInventory = this.moduleInventory;
            if (iModuleInventory instanceof LinkableBlockEntity) {
                be = (LinkableBlockEntity)iModuleInventory;
                ((LinkableBlockEntity)be).propagate((ILinkedAction)new ILinkedAction.ModuleRemoved(module.getModuleType(), false), (LinkableBlockEntity)be);
            }
        }
        if ((be = stack.getItem()) instanceof ModuleItem) {
            module = (ModuleItem)((Object)be);
            this.moduleInventory.onModuleInserted(stack, module.getModuleType(), false);
            iModuleInventory = this.moduleInventory;
            if (iModuleInventory instanceof LinkableBlockEntity) {
                be = (LinkableBlockEntity)iModuleInventory;
                ((LinkableBlockEntity)be).propagate((ILinkedAction)new ILinkedAction.ModuleInserted(stack, module, false), (LinkableBlockEntity)be);
            }
        }
    }
}

