/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.inventory;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SCTags;
import net.geforcemods.securitycraft.inventory.ItemContainer;
import net.geforcemods.securitycraft.items.KeycardHolderItem;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.world.Container;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class KeycardHolderMenu
extends AbstractContainerMenu {
    public static final int CONTAINER_SIZE = 5;
    private final ItemContainer keycardHolderInv;

    public KeycardHolderMenu(int id, Inventory playerInventory, ItemContainer keycardHolderInv) {
        super((MenuType)SCContent.KEYCARD_HOLDER_MENU.get(), id);
        int i;
        this.keycardHolderInv = keycardHolderInv;
        for (i = 0; i < 5; ++i) {
            this.addSlot(new Slot(this, keycardHolderInv, i, 44 + i * 18, 20){

                public boolean mayPlace(ItemStack stack) {
                    return stack.is(SCTags.Items.KEYCARD_HOLDER_CAN_HOLD);
                }
            });
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, i * 18 + 51));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 109));
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack slotStackCopy = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            slotStackCopy = slotStack.copy();
            if (index < 5) {
                if (!this.moveItemStackTo(slotStack, 5, 41, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotStack, slotStackCopy);
            } else if (!this.moveItemStackTo(slotStack, 0, 5, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == slotStackCopy.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, slotStack);
        }
        return slotStackCopy;
    }

    public void clicked(int slot, int dragType, ClickType clickType, Player player) {
        if (slot < 0 || this.getSlot(slot) == null || !(this.getSlot(slot).getItem().getItem() instanceof KeycardHolderItem)) {
            super.clicked(slot, dragType, clickType, player);
        }
    }

    public boolean stillValid(Player player) {
        return PlayerUtils.getItemStackFromAnyHand(player, (Item)SCContent.KEYCARD_HOLDER.get()) == this.keycardHolderInv.getContainerStack();
    }

    public void removed(Player player) {
        super.removed(player);
        this.keycardHolderInv.stopOpen((ContainerUser)player);
    }
}

