/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.inventory;

import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;

public class ItemContainer
implements Container {
    private final ItemStack containerStack;
    private final NonNullList<ItemStack> inventory;
    private final int maxStackSize;

    private ItemContainer(ItemStack containerStack, int inventorySize, int maxStackSize) {
        this.containerStack = containerStack;
        this.maxStackSize = maxStackSize;
        this.inventory = NonNullList.withSize((int)inventorySize, (Object)ItemStack.EMPTY);
        this.load();
    }

    public static ItemContainer briefcase(ItemStack briefcase) {
        return new ItemContainer(briefcase, 12, 99);
    }

    public static ItemContainer keycardHolder(ItemStack keycardHolder) {
        return new ItemContainer(keycardHolder, 5, 1);
    }

    public int getContainerSize() {
        return this.inventory.size();
    }

    public ItemStack getItem(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public void load() {
        ((ItemContainerContents)this.containerStack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).copyInto(this.inventory);
    }

    public void save() {
        this.containerStack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.inventory));
    }

    public ItemStack removeItem(int index, int size) {
        ItemStack stack = this.getItem(index);
        if (!stack.isEmpty()) {
            if (stack.getCount() > size) {
                stack = stack.split(size);
                this.setChanged();
            } else {
                this.setItem(index, ItemStack.EMPTY);
            }
        }
        return stack;
    }

    public ItemStack removeItemNoUpdate(int index) {
        ItemStack stack = this.getItem(index);
        this.setItem(index, ItemStack.EMPTY);
        return stack;
    }

    public void setItem(int index, ItemStack itemStack) {
        this.inventory.set(index, (Object)itemStack);
        if (!itemStack.isEmpty() && itemStack.getCount() > this.getMaxStackSize()) {
            itemStack.setCount(this.getMaxStackSize());
        }
        this.setChanged();
    }

    public int getMaxStackSize() {
        return this.maxStackSize;
    }

    public void setChanged() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            if (this.getItem(i).isEmpty() || this.getItem(i).getCount() != 0) continue;
            this.inventory.set(i, (Object)ItemStack.EMPTY);
        }
        this.save();
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void startOpen(ContainerUser player) {
    }

    public void stopOpen(ContainerUser player) {
        this.save();
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return true;
    }

    public void clearContent() {
        for (int i = 0; i < this.inventory.size(); ++i) {
            this.inventory.set(i, (Object)ItemStack.EMPTY);
        }
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.inventory) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getContainerStack() {
        return this.containerStack;
    }
}

