/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity.sentry;

import java.util.EnumSet;
import java.util.function.Supplier;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;

public class AttackRangedIfEnabledGoal
extends Goal {
    private Sentry sentry;
    private LivingEntity attackTarget;
    private int rangedAttackTime;
    private final Supplier<Integer> maxAttackTime;
    private final float attackRadius;

    public AttackRangedIfEnabledGoal(RangedAttackMob attacker, Supplier<Integer> maxAttackTime, float maxAttackDistance) {
        this.sentry = (Sentry)attacker;
        this.rangedAttackTime = -1;
        this.maxAttackTime = maxAttackTime;
        this.attackRadius = maxAttackDistance;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        LivingEntity potentialTarget = this.sentry.getTarget();
        if (potentialTarget == null || this.sentry.isShutDown()) {
            return false;
        }
        this.attackTarget = potentialTarget;
        return this.sentry.getMode() != Sentry.SentryMode.IDLE;
    }

    public void stop() {
        this.attackTarget = null;
        this.rangedAttackTime = -3;
    }

    public void tick() {
        double targetDistance = this.sentry.distanceToSqr(this.attackTarget.getX(), this.attackTarget.getBoundingBox().minY, this.attackTarget.getZ());
        this.sentry.getLookControl().setLookAt((Entity)this.attackTarget, 30.0f, 30.0f);
        if (--this.rangedAttackTime == 0) {
            if (!this.sentry.getSensing().hasLineOfSight((Entity)this.attackTarget)) {
                return;
            }
            float f = Mth.sqrt((float)((float)targetDistance)) / this.attackRadius;
            float distanceFactor = Mth.clamp((float)f, (float)0.1f, (float)1.0f);
            this.sentry.performRangedAttack(this.attackTarget, distanceFactor);
            this.rangedAttackTime = Mth.floor((float)this.maxAttackTime.get().intValue());
        } else if (this.rangedAttackTime < 0) {
            this.rangedAttackTime = Mth.floor((float)this.maxAttackTime.get().intValue());
        }
    }
}

