/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.function.Consumer;
import net.geforcemods.securitycraft.items.KeycardItem;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import org.apache.commons.lang3.StringUtils;

public record KeycardData(int signature, boolean limited, int usesLeft, Optional<String> usableBy) implements TooltipProvider
{
    public static final KeycardData DEFAULT = new KeycardData(0, false, 0, Optional.empty());
    public static final Codec<KeycardData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("signature").forGetter(KeycardData::signature), (App)Codec.BOOL.fieldOf("limited").forGetter(KeycardData::limited), (App)Codec.INT.fieldOf("uses_left").forGetter(KeycardData::usesLeft), (App)Codec.STRING.optionalFieldOf("usable_by").forGetter(KeycardData::usableBy)).apply((Applicative)instance, KeycardData::new));
    public static final StreamCodec<ByteBuf, KeycardData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, KeycardData::signature, (StreamCodec)ByteBufCodecs.BOOL, KeycardData::limited, (StreamCodec)ByteBufCodecs.VAR_INT, KeycardData::usesLeft, (StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.STRING_UTF8), KeycardData::usableBy, KeycardData::new);

    public void addToTooltip(Item.TooltipContext ctx, Consumer<Component> lineAdder, TooltipFlag flag, DataComponentGetter componentGetter) {
        lineAdder.accept((Component)Component.translatable((String)"tooltip.securitycraft:keycard.signature", (Object[])new Object[]{StringUtils.leftPad((String)("" + this.signature), (int)5, (String)"0")}).setStyle(Utils.GRAY_STYLE));
        lineAdder.accept((Component)Component.translatable((String)"tooltip.securitycraft:keycard.usable_by", (Object[])new Object[]{this.usableBy.map(Component::literal).orElse(Component.translatable((String)"tooltip.securitycraft:keycard.everyone"))}).setStyle(Utils.GRAY_STYLE));
        if (this.limited) {
            lineAdder.accept((Component)Component.translatable((String)"tooltip.securitycraft:keycard.uses", (Object[])new Object[]{this.usesLeft}).setStyle(Utils.GRAY_STYLE));
        } else {
            lineAdder.accept(KeycardItem.LIMITED_INFO);
        }
    }

    public KeycardData setSignature(int signature) {
        return this.setSignatureAndUsableBy(signature, this.usableBy);
    }

    public KeycardData setSignatureAndUsableBy(int signature, Optional<String> usableBy) {
        return new KeycardData(signature, this.limited, this.usesLeft, usableBy);
    }

    public KeycardData setUsesLeft(int usesLeft) {
        return this.setLimitedAndUsesLeft(this.limited, usesLeft);
    }

    public KeycardData setLimitedAndUsesLeft(boolean limited, int usesLeft) {
        return new KeycardData(this.signature, limited, usesLeft, this.usableBy);
    }
}

