/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.commands;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.server.players.NameAndId;

public class SingleGameProfileArgument
extends GameProfileArgument {
    public static SingleGameProfileArgument singleGameProfile() {
        return new SingleGameProfileArgument();
    }

    public static NameAndId getGameProfile(CommandContext<CommandSourceStack> ctx, String name) throws CommandSyntaxException {
        return (NameAndId)SingleGameProfileArgument.getGameProfiles(ctx, (String)name).iterator().next();
    }

    public GameProfileArgument.Result parse(StringReader reader) throws CommandSyntaxException {
        GameProfileArgument.Result result = super.parse(reader);
        if (result instanceof GameProfileArgument.SelectorResult) {
            return source -> {
                Collection profiles = result.getNames(source);
                if (profiles.size() > 1) {
                    throw EntityArgument.ERROR_NOT_SINGLE_PLAYER.create();
                }
                return profiles;
            };
        }
        return result;
    }
}

