/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.UUID;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.commands.SingleGameProfileArgument;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.commands.FillCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.NameAndId;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.apache.commons.lang3.RandomStringUtils;

public class OwnerCommand {
    private static final SimpleCommandExceptionType ERROR_SET_FAILED = new SimpleCommandExceptionType((Message)Component.translatableWithFallback((String)"commands.securitycraft.owner.set.failed", (String)"There is no ownable block at the given position or it is already owned by the given player"));
    private static final SimpleCommandExceptionType ERROR_FILL_FAILED = new SimpleCommandExceptionType((Message)Component.translatableWithFallback((String)"commands.securitycraft.owner.fill.failed", (String)"There are no ownable blocks in the given area or they are already owned by the given player"));

    private OwnerCommand() {
    }

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"owner").requires(ctx -> ctx.hasPermission(2))).then(Commands.literal((String)"set").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.literal((String)"reset").executes(ctx -> OwnerCommand.setOwner((CommandSourceStack)ctx.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext)ctx, (String)"pos"), "ownerUUID", "owner")))).then(Commands.literal((String)"random").executes(ctx -> OwnerCommand.setRandomOwner((CommandSourceStack)ctx.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext)ctx, (String)"pos"))))).then(Commands.literal((String)"player").then(Commands.argument((String)"owner", (ArgumentType)SingleGameProfileArgument.singleGameProfile()).executes(ctx -> OwnerCommand.setOwner((CommandSourceStack)ctx.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext)ctx, (String)"pos"), SingleGameProfileArgument.getGameProfile((CommandContext<CommandSourceStack>)ctx, "owner")))))))).then(Commands.literal((String)"fill").then(Commands.argument((String)"from", (ArgumentType)BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"to", (ArgumentType)BlockPosArgument.blockPos()).then(Commands.literal((String)"reset").executes(ctx -> OwnerCommand.fillOwner((CommandContext<CommandSourceStack>)ctx, "ownerUUID", "owner")))).then(Commands.literal((String)"random").executes(ctx -> OwnerCommand.fillRandomOwner((CommandContext<CommandSourceStack>)ctx)))).then(Commands.literal((String)"player").then(Commands.argument((String)"owner", (ArgumentType)SingleGameProfileArgument.singleGameProfile()).executes(ctx -> OwnerCommand.fillOwner((CommandContext<CommandSourceStack>)ctx, SingleGameProfileArgument.getGameProfile((CommandContext<CommandSourceStack>)ctx, "owner"))))))));
    }

    private static int setRandomOwner(CommandSourceStack source, BlockPos pos) throws CommandSyntaxException {
        return OwnerCommand.setOwner(source, pos, UUID.randomUUID().toString(), RandomStringUtils.randomAlphanumeric((int)10));
    }

    private static int setOwner(CommandSourceStack source, BlockPos pos, NameAndId gameProfile) throws CommandSyntaxException {
        return OwnerCommand.setOwner(source, pos, gameProfile.id().toString(), gameProfile.name());
    }

    private static int setOwner(CommandSourceStack source, BlockPos pos, String uuid, String name) throws CommandSyntaxException {
        ServerLevel level = source.getLevel();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof IOwnable)) {
            throw ERROR_SET_FAILED.create();
        }
        IOwnable ownable = (IOwnable)blockEntity;
        Owner previousOwner = ownable.getOwner();
        if (!previousOwner.getUUID().equals(uuid) || !previousOwner.getName().equals(name)) {
            BlockState state = ((BlockEntity)ownable).getBlockState();
            Owner oldOwner = ownable.getOwner().copy();
            ownable.setOwner(uuid, name);
            ownable.onOwnerChanged(state, (Level)level, pos, null, oldOwner, ownable.getOwner());
            ownable.getOwner().setValidated(true);
            level.sendBlockUpdated(pos, state, state, 3);
            source.sendSuccess(() -> Component.translatableWithFallback((String)"commands.securitycraft.owner.set.success", (String)"Set the owner at %s, %s, %s", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}), true);
            return 1;
        }
        throw ERROR_SET_FAILED.create();
    }

    private static int fillRandomOwner(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return OwnerCommand.fillOwner(ctx, UUID.randomUUID().toString(), RandomStringUtils.randomAlphanumeric((int)10));
    }

    private static int fillOwner(CommandContext<CommandSourceStack> ctx, NameAndId gameProfile) throws CommandSyntaxException {
        return OwnerCommand.fillOwner(ctx, gameProfile.id().toString(), gameProfile.name());
    }

    private static int fillOwner(CommandContext<CommandSourceStack> ctx, String uuid, String name) throws CommandSyntaxException {
        int commandModificationBlockLimit;
        BoundingBox area = BoundingBox.fromCorners((Vec3i)BlockPosArgument.getLoadedBlockPos(ctx, (String)"from"), (Vec3i)BlockPosArgument.getLoadedBlockPos(ctx, (String)"to"));
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerLevel level = source.getLevel();
        int blockCount = area.getXSpan() * area.getYSpan() * area.getZSpan();
        if (blockCount > (commandModificationBlockLimit = level.getGameRules().getInt(GameRules.RULE_COMMAND_MODIFICATION_BLOCK_LIMIT))) {
            throw FillCommand.ERROR_AREA_TOO_LARGE.create((Object)commandModificationBlockLimit, (Object)blockCount);
        }
        ArrayList<OwnerChange> modifiedBlocks = new ArrayList<OwnerChange>();
        for (BlockPos pos : BlockPos.betweenClosed((int)area.minX(), (int)area.minY(), (int)area.minZ(), (int)area.maxX(), (int)area.maxY(), (int)area.maxZ())) {
            IOwnable ownable;
            Owner previousOwner;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (!(blockEntity instanceof IOwnable) || (previousOwner = (ownable = (IOwnable)blockEntity).getOwner()).getUUID().equals(uuid) && previousOwner.getName().equals(name)) continue;
            Owner oldOwner = ownable.getOwner().copy();
            ownable.setOwner(uuid, name);
            modifiedBlocks.add(new OwnerChange((BlockEntity)ownable, oldOwner));
        }
        int blocksModified = modifiedBlocks.size();
        if (blocksModified == 0) {
            throw ERROR_FILL_FAILED.create();
        }
        for (OwnerChange ownerChange : modifiedBlocks) {
            BlockEntity be = ownerChange.be;
            BlockPos pos = be.getBlockPos();
            BlockState state = be.getBlockState();
            IOwnable ownable = (IOwnable)be;
            ownable.onOwnerChanged(state, (Level)level, pos, null, ownerChange.oldOwner, ownable.getOwner());
            ownable.getOwner().setValidated(true);
            level.sendBlockUpdated(pos, state, state, 3);
        }
        source.sendSuccess(() -> Component.translatableWithFallback((String)"commands.securitycraft.owner.fill.success", (String)"Successfully set the owner of %s block(s)", (Object[])new Object[]{blocksModified}), true);
        return blocksModified;
    }

    private record OwnerChange(BlockEntity be, Owner oldOwner) {
    }
}

