/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Iterator;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.client.SetCameraView;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.network.PacketDistributor;

public class SecurityCameraBlock
extends DisguisableBlock
implements SimpleWaterloggedBlock {
    public static final EnumProperty<Direction> FACING = EnumProperty.create((String)"facing", Direction.class, facing -> facing != Direction.UP);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty BEING_VIEWED = BooleanProperty.create((String)"being_viewed");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SHAPE_SOUTH = Shapes.create((AABB)new AABB((double)0.275f, 0.25, 0.0, (double)0.7f, (double)0.8f, (double)0.85f));
    private static final VoxelShape SHAPE_NORTH = Shapes.create((AABB)new AABB((double)0.275f, 0.25, (double)0.15f, (double)0.7f, (double)0.8f, 1.0));
    private static final VoxelShape SHAPE_WEST = Shapes.create((AABB)new AABB(0.125, 0.25, (double)0.275f, 1.0, (double)0.8f, (double)0.725f));
    private static final VoxelShape SHAPE = Shapes.create((AABB)new AABB(0.0, 0.25, (double)0.275f, (double)0.85f, (double)0.8f, (double)0.725f));
    private static final VoxelShape SHAPE_DOWN = Shapes.or((VoxelShape)Block.box((double)7.0, (double)15.0, (double)5.0, (double)9.0, (double)16.0, (double)11.0), (VoxelShape)Shapes.or((VoxelShape)Block.box((double)6.0, (double)15.0, (double)6.0, (double)7.0, (double)16.0, (double)10.0), (VoxelShape)Shapes.or((VoxelShape)Block.box((double)5.0, (double)15.0, (double)7.0, (double)6.0, (double)16.0, (double)9.0), (VoxelShape)Shapes.or((VoxelShape)Block.box((double)9.0, (double)15.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), (VoxelShape)Shapes.or((VoxelShape)Block.box((double)10.0, (double)15.0, (double)7.0, (double)11.0, (double)16.0, (double)9.0), (VoxelShape)Block.box((double)7.0, (double)14.0, (double)7.0, (double)9.0, (double)15.0, (double)9.0))))));

    public SecurityCameraBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)BEING_VIEWED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (stack.is((Item)SCContent.CAMERA_MONITOR.get())) {
            return InteractionResult.PASS;
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        SecurityCameraBlockEntity be;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SecurityCameraBlockEntity && (be = (SecurityCameraBlockEntity)blockEntity).isOwnedBy((Entity)player)) {
            if (!level.isClientSide()) {
                player.openMenu((MenuProvider)be);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (player.isCreative() && (blockEntity = level.getBlockEntity(pos)) instanceof IModuleInventory) {
            IModuleInventory inv = (IModuleInventory)blockEntity;
            inv.getInventory().clear();
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public void affectNeighborsAfterRemoval(BlockState state, ServerLevel level, BlockPos pos, boolean isMoving) {
        level.updateNeighborsAt(pos.north(), state.getBlock());
        level.updateNeighborsAt(pos.south(), state.getBlock());
        level.updateNeighborsAt(pos.east(), state.getBlock());
        level.updateNeighborsAt(pos.west(), state.getBlock());
        super.affectNeighborsAfterRemoval(state, level, pos, isMoving);
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        BlockState disguisedState = IDisguisable.getDisguisedBlockState(level.getBlockEntity(pos)).orElse(state);
        if (disguisedState.getBlock() != this) {
            return disguisedState.getShape(level, pos, ctx);
        }
        return switch ((Direction)state.getValue(FACING)) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.DOWN -> SHAPE_DOWN;
            default -> SHAPE;
        };
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction direction = ctx.getClickedFace();
        if (direction != Direction.UP) {
            Level level = ctx.getLevel();
            BlockPos pos = ctx.getClickedPos();
            BlockState state = (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)direction);
            if (!this.canSurvive(state, (LevelReader)level, pos)) {
                Direction newFacing;
                Iterator iterator = Direction.Plane.HORIZONTAL.iterator();
                while (iterator.hasNext() && !this.canSurvive(state = (BlockState)state.setValue(FACING, (Comparable)(newFacing = (Direction)iterator.next())), (LevelReader)level, pos)) {
                }
            }
            return (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos).getType() == Fluids.WATER));
        }
        return null;
    }

    public void mountCamera(Level level, BlockPos pos, Player player) {
        if (!level.isClientSide()) {
            ServerLevel serverLevel = (ServerLevel)level;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SectionPos chunkPos = SectionPos.of((BlockPos)pos);
            int viewDistance = Mth.clamp((int)serverPlayer.requestedViewDistance(), (int)2, (int)serverLevel.getServer().getPlayerList().getViewDistance());
            Entity entity = serverPlayer.getCamera();
            if (entity instanceof SecurityCamera) {
                SecurityCamera cam = (SecurityCamera)entity;
                cam.discard();
            }
            SecurityCamera dummyEntity = new SecurityCamera(level, pos);
            dummyEntity.setChunkLoadingDistance(viewDistance);
            serverPlayer.camera = dummyEntity;
            level.addFreshEntity((Entity)dummyEntity);
            for (int x = chunkPos.getX() - viewDistance; x <= chunkPos.getX() + viewDistance; ++x) {
                for (int z = chunkPos.getZ() - viewDistance; z <= chunkPos.getZ() + viewDistance; ++z) {
                    SecurityCraft.CAMERA_TICKET_CONTROLLER.forceChunk(serverLevel, (Entity)dummyEntity, x, z, true, false);
                }
            }
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SetCameraView(dummyEntity.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            entity = level.getBlockEntity(pos);
            if (entity instanceof SecurityCameraBlockEntity) {
                SecurityCameraBlockEntity cam = (SecurityCameraBlockEntity)entity;
                cam.startViewing();
            }
        }
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction facing = (Direction)state.getValue(FACING);
        return BlockUtils.isSideSolid(level, pos.relative(facing.getOpposite()), facing);
    }

    @Override
    public BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            tickAccess.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        return super.updateShape(state, level, tickAccess, pos, facing, facingPos, facingState, random);
    }

    @Override
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getSignal(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue() && ((IModuleInventory)level.getBlockEntity(pos)).isModuleEnabled(ModuleType.REDSTONE)) {
            return 15;
        }
        return 0;
    }

    public int getDirectSignal(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue() && ((IModuleInventory)level.getBlockEntity(pos)).isModuleEnabled(ModuleType.REDSTONE) && state.getValue(FACING) == side) {
            return 15;
        }
        return 0;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, Orientation orientation, boolean flag) {
        if (!this.canSurvive(state, (LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, POWERED, BEING_VIEWED, WATERLOGGED});
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SecurityCameraBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return SecurityCameraBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)SCContent.SECURITY_CAMERA_BLOCK_ENTITY.get()), LevelUtils::blockEntityTicker);
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        Direction facing = (Direction)state.getValue(FACING);
        switch (mirror) {
            case LEFT_RIGHT: {
                if (facing.getAxis() != Direction.Axis.Z) break;
                return (BlockState)state.setValue(FACING, (Comparable)facing.getOpposite());
            }
            case FRONT_BACK: {
                if (facing.getAxis() != Direction.Axis.X) break;
                return (BlockState)state.setValue(FACING, (Comparable)facing.getOpposite());
            }
        }
        return state;
    }
}

