/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILinkedAction;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.blockentities.LaserBlockBlockEntity;
import net.geforcemods.securitycraft.blocks.LaserBlock;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.misc.CustomDamageSources;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LaserFieldBlock
extends OwnableBlock
implements SimpleWaterloggedBlock {
    public static final IntegerProperty BOUNDTYPE = IntegerProperty.create((String)"boundtype", (int)1, (int)3);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SHAPE_X = Block.box((double)0.0, (double)6.75, (double)6.75, (double)16.0, (double)9.25, (double)9.25);
    private static final VoxelShape SHAPE_Y = Block.box((double)6.75, (double)0.0, (double)6.75, (double)9.25, (double)16.0, (double)9.25);
    private static final VoxelShape SHAPE_Z = Block.box((double)6.75, (double)6.75, (double)0.0, (double)9.25, (double)9.25, (double)16.0);

    public LaserFieldBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BOUNDTYPE, (Comparable)Integer.valueOf(1))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return Shapes.empty();
    }

    public BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            tickAccess.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        return super.updateShape(state, level, tickAccess, pos, facing, facingPos, facingState, random);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity, InsideBlockEffectApplier effectApplier, boolean stillInside) {
        if (!level.isClientSide() && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (!this.getShape(state, (BlockGetter)level, pos, CollisionContext.of((Entity)entity)).bounds().move(pos).intersects(entity.getBoundingBox())) {
                return;
            }
            for (int i = 0; i < (Integer)ConfigHandler.SERVER.laserBlockRange.get(); ++i) {
                OwnableEntity ownableEntity;
                Player player;
                BlockEntity blockEntity;
                BlockPos offsetPos = pos.relative(LaserFieldBlock.getFieldDirection(state), i);
                BlockState offsetState = level.getBlockState(offsetPos);
                Block offsetBlock = offsetState.getBlock();
                if (offsetBlock != SCContent.LASER_BLOCK.get() || !((blockEntity = level.getBlockEntity(offsetPos)) instanceof LaserBlockBlockEntity)) continue;
                LaserBlockBlockEntity laser = (LaserBlockBlockEntity)blockEntity;
                if (laser.isAllowed(entity) || laser.isConsideredInvisible(livingEntity)) {
                    return;
                }
                if (entity instanceof Player && laser.isOwnedBy((Entity)(player = (Player)entity)) && laser.ignoresOwner()) break;
                if (entity instanceof OwnableEntity && laser.allowsOwnableEntity(ownableEntity = (OwnableEntity)entity)) {
                    return;
                }
                if (laser.isModuleEnabled(ModuleType.REDSTONE)) {
                    if (laser.timeSinceLastToggle() < 500L) {
                        laser.setLastToggleTime(System.currentTimeMillis());
                    } else {
                        int signalLength = laser.getSignalLength();
                        boolean wasPowered = (Boolean)offsetState.getValue((Property)LaserBlock.POWERED);
                        laser.setLastToggleTime(System.currentTimeMillis());
                        level.setBlockAndUpdate(offsetPos, (BlockState)offsetState.cycle((Property)LaserBlock.POWERED));
                        BlockUtils.updateIndirectNeighbors(level, offsetPos, (Block)SCContent.LASER_BLOCK.get());
                        laser.propagate(new ILinkedAction.StateChanged<Boolean>((Property<Boolean>)LaserBlock.POWERED, wasPowered, !wasPowered), laser);
                        if (signalLength > 0) {
                            level.scheduleTick(offsetPos, (Block)SCContent.LASER_BLOCK.get(), signalLength);
                        }
                    }
                }
                if (!laser.isModuleEnabled(ModuleType.HARMING)) break;
                double damage = (Double)ConfigHandler.SERVER.laserDamage.get();
                livingEntity.hurt(CustomDamageSources.laser(level.registryAccess()), (float)damage);
                break;
            }
        }
    }

    public static Direction getFieldDirection(BlockState state) {
        return switch ((Integer)state.getValue((Property)BOUNDTYPE)) {
            case 1 -> Direction.UP;
            case 2 -> Direction.SOUTH;
            case 3 -> Direction.EAST;
            default -> null;
        };
    }

    public static int getBoundType(Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.UP, Direction.DOWN -> 1;
            case Direction.NORTH, Direction.SOUTH -> 2;
            case Direction.EAST, Direction.WEST -> 3;
        };
    }

    public void destroy(LevelAccessor level, BlockPos pos, BlockState state) {
        if (!level.isClientSide()) {
            int boundType = (Integer)state.getValue((Property)BOUNDTYPE);
            Direction direction = Direction.from3DDataValue((int)((boundType - 1) * 2));
            BlockUtils.removeInSequence((directionToCheck, stateToCheck) -> stateToCheck.getBlock() == this && (Integer)stateToCheck.getValue((Property)BOUNDTYPE) == boundType, level, pos, direction, direction.getOpposite());
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return switch ((Integer)state.getValue((Property)BOUNDTYPE)) {
            case 1 -> SHAPE_Y;
            case 2 -> SHAPE_Z;
            case 3 -> SHAPE_X;
            default -> Shapes.empty();
        };
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return this.getPotentiallyWaterloggedState(1, ctx.getLevel(), ctx.getClickedPos());
    }

    public BlockState getPotentiallyWaterloggedState(int boundType, Level level, BlockPos pos) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)BOUNDTYPE, (Comparable)Integer.valueOf(boundType))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos).getType() == Fluids.WATER));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BOUNDTYPE, WATERLOGGED});
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state, boolean includeData, Player player) {
        return ItemStack.EMPTY;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new OwnableBlockEntity((BlockEntityType)SCContent.ABSTRACT_BLOCK_ENTITY.get(), pos, state);
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        BlockState blockState;
        if (rot == Rotation.CLOCKWISE_180) {
            blockState = state;
        } else {
            blockState = (BlockState)state.setValue((Property)BOUNDTYPE, (Comparable)(switch ((Integer)state.getValue((Property)BOUNDTYPE)) {
                case 2 -> 3;
                case 3 -> 2;
                default -> 1;
            }));
        }
        return blockState;
    }
}

