/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasscodeConvertible;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.FrameBlockEntity;
import net.geforcemods.securitycraft.blockentities.KeypadBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.blocks.FrameBlock;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class KeypadBlock
extends DisguisableBlock {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public KeypadBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        KeypadBlockEntity be = (KeypadBlockEntity)level.getBlockEntity(pos);
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue() && be.getSignalLength() > 0) {
            return InteractionResult.PASS;
        }
        if (!level.isClientSide()) {
            if (be.isDisabled()) {
                player.displayClientMessage((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            } else if (be.verifyPasscodeSet(level, pos, be, player)) {
                if (be.isDenied((Entity)player)) {
                    if (be.sendsDenylistMessage()) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:module.onDenylist", new Object[0]), ChatFormatting.RED);
                    }
                } else if (be.isAllowed((Entity)player)) {
                    if (be.sendsAllowlistMessage()) {
                        PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:module.onAllowlist", new Object[0]), ChatFormatting.GREEN);
                    }
                    this.activate(state, level, pos, be.getSignalLength());
                } else {
                    be.openPasscodeGUI(level, pos, player);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void activate(BlockState state, Level level, BlockPos pos, int signalLength) {
        level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)POWERED));
        BlockUtils.updateIndirectNeighbors(level, pos, (Block)SCContent.KEYPAD.get());
        if (signalLength > 0) {
            level.scheduleTick(pos, (Block)this, signalLength);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
            BlockUtils.updateIndirectNeighbors((Level)level, pos, (Block)SCContent.KEYPAD.get());
        }
    }

    public void affectNeighborsAfterRemoval(BlockState state, ServerLevel level, BlockPos pos, boolean isMoving) {
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            BlockUtils.updateIndirectNeighbors((Level)level, pos, (Block)this);
        }
        super.affectNeighborsAfterRemoval(state, level, pos, isMoving);
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public boolean shouldCheckWeakPower(BlockState state, SignalGetter level, BlockPos pos, Direction side) {
        return false;
    }

    public int getSignal(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        return (Boolean)state.getValue((Property)POWERED) != false ? 15 : 0;
    }

    public int getDirectSignal(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        return (Boolean)state.getValue((Property)POWERED) != false ? 15 : 0;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)super.getStateForPlacement(ctx).setValue(FACING, (Comparable)ctx.getHorizontalDirection().getOpposite())).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, POWERED, WATERLOGGED});
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new KeypadBlockEntity(pos, state);
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue(FACING)));
    }

    public static class Convertible
    implements IPasscodeConvertible {
        @Override
        public boolean isUnprotectedBlock(BlockState state) {
            return state.is((Block)SCContent.FRAME.get());
        }

        @Override
        public boolean isProtectedBlock(BlockState state) {
            return state.is((Block)SCContent.KEYPAD.get());
        }

        @Override
        public boolean protect(Player player, Level level, BlockPos pos) {
            FrameBlockEntity be = (FrameBlockEntity)level.getBlockEntity(pos);
            if (be.getCurrentCamera() != null) {
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(((FrameBlock)((Object)SCContent.FRAME.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:frame.cannotConvert", new Object[0]), ChatFormatting.RED);
                return false;
            }
            Owner owner = be.getOwner();
            be.dropAllModules();
            level.setBlockAndUpdate(pos, (BlockState)((BlockState)((KeypadBlock)SCContent.KEYPAD.get()).defaultBlockState().setValue(FACING, (Comparable)((Direction)level.getBlockState(pos).getValue(FrameBlock.FACING)))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
            ((IOwnable)level.getBlockEntity(pos)).setOwner(owner.getUUID(), owner.getName());
            return true;
        }

        @Override
        public boolean unprotect(Player player, Level level, BlockPos pos) {
            Owner owner = ((IOwnable)level.getBlockEntity(pos)).getOwner();
            ((IModuleInventory)level.getBlockEntity(pos)).dropAllModules();
            level.setBlockAndUpdate(pos, (BlockState)((FrameBlock)((Object)SCContent.FRAME.get())).defaultBlockState().setValue(FrameBlock.FACING, (Comparable)((Direction)level.getBlockState(pos).getValue(FACING))));
            ((IOwnable)level.getBlockEntity(pos)).setOwner(owner.getUUID(), owner.getName());
            return true;
        }
    }
}

