/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.blockentities.AlarmBlockEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.network.client.OpenScreen;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.LevelUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.network.PacketDistributor;

public class AlarmBlock
extends OwnableBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final EnumProperty<Direction> FACING = BlockStateProperties.FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SHAPE_EAST = Block.box((double)0.0, (double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0);
    private static final VoxelShape SHAPE_WEST = Block.box((double)8.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    private static final VoxelShape SHAPE_NORTH = Block.box((double)4.0, (double)4.0, (double)8.0, (double)12.0, (double)12.0, (double)16.0);
    private static final VoxelShape SHAPE_SOUTH = Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)8.0);
    private static final VoxelShape SHAPE_UP = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
    private static final VoxelShape SHAPE_DOWN = Block.box((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public AlarmBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.UP)).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        AlarmBlockEntity be;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AlarmBlockEntity && (be = (AlarmBlockEntity)blockEntity).isOwnedBy((Entity)player)) {
            if (!level.isClientSide()) {
                if (be.isDisabled()) {
                    player.displayClientMessage((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
                } else {
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new OpenScreen(OpenScreen.DataType.ALARM, pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction facing = (Direction)state.getValue(FACING);
        return BlockUtils.isSideSolid(level, pos.relative(facing.getOpposite()), facing);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return direction != null && direction.getAxis() != Direction.Axis.Y;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, Orientation orientation, boolean flag) {
        if (!this.canSurvive(state, (LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction facing;
        BlockPos pos;
        Level level = ctx.getLevel();
        return BlockUtils.isSideSolid((LevelReader)level, (pos = ctx.getClickedPos()).relative((facing = ctx.getClickedFace()).getOpposite()), facing) ? (BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)facing)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos).getType() == Fluids.WATER)) : null;
    }

    public BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            tickAccess.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        return super.updateShape(state, level, tickAccess, pos, facing, facingPos, facingState, random);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean flag) {
        if (!level.isClientSide()) {
            level.scheduleTick(pos, state.getBlock(), 5);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!level.isClientSide()) {
            this.playSoundAndUpdate((Level)level, pos);
            level.scheduleTick(pos, state.getBlock(), 5);
        }
    }

    public void onNeighborChange(BlockState state, LevelReader levelReader, BlockPos pos, BlockPos neighbor) {
        if (levelReader.isClientSide() || !(levelReader instanceof Level)) {
            return;
        }
        Level level = (Level)levelReader;
        this.playSoundAndUpdate(level, pos);
        Direction facing = (Direction)state.getValue(FACING);
        if (!BlockUtils.isSideSolid((LevelReader)level, pos.relative(facing.getOpposite()), facing)) {
            level.destroyBlock(pos, true);
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return switch ((Direction)state.getValue(FACING)) {
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.UP -> SHAPE_UP;
            case Direction.DOWN -> SHAPE_DOWN;
            default -> Shapes.block();
        };
    }

    private void playSoundAndUpdate(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (state.getBlock() != SCContent.ALARM.get()) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AlarmBlockEntity) {
            AlarmBlockEntity be = (AlarmBlockEntity)blockEntity;
            if (level.getBestNeighborSignal(pos) > 0) {
                boolean isPowered = be.isPowered();
                if (!isPowered) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true)));
                    be.setPowered(true);
                }
            } else {
                boolean isPowered = be.isPowered();
                if (isPowered) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
                    be.setPowered(false);
                }
            }
        }
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (player.isCreative() && (blockEntity = level.getBlockEntity(pos)) instanceof IModuleInventory) {
            IModuleInventory inv = (IModuleInventory)blockEntity;
            inv.getInventory().clear();
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, LIT, WATERLOGGED});
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AlarmBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return AlarmBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)SCContent.ALARM_BLOCK_ENTITY.get()), LevelUtils::blockEntityTicker);
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        Direction facing = (Direction)state.getValue(FACING);
        switch (mirror) {
            case LEFT_RIGHT: {
                if (facing.getAxis() != Direction.Axis.Z) break;
                return (BlockState)state.setValue(FACING, (Comparable)facing.getOpposite());
            }
            case FRONT_BACK: {
                if (facing.getAxis() != Direction.Axis.X) break;
                return (BlockState)state.setValue(FACING, (Comparable)facing.getOpposite());
            }
        }
        return state;
    }
}

