/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import java.lang.runtime.SwitchBootstraps;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.ToIntFunction;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.NamedBlockEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.RiftStabilizerBlock;
import net.geforcemods.securitycraft.misc.BlockEntityTracker;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.server.SyncRiftStabilizer;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.geforcemods.securitycraft.util.IToggleableEntries;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;

public class RiftStabilizerBlockEntity
extends DisguisableBlockEntity
implements ITickingBlockEntity,
ILockable,
IToggleableEntries<TeleportationType> {
    private final Option.IntOption signalLength = new Option.IntOption("signalLength", 60, 0, 400, 5);
    private final Option.IntOption range = new Option.IntOption("range", 5, 1, 15, 1);
    private final Option.DisabledOption disabled = new Option.DisabledOption(false);
    private Option.IgnoreOwnerOption ignoreOwner = new Option.IgnoreOwnerOption(true);
    private final Map<TeleportationType, Boolean> teleportationFilter = new EnumMap<TeleportationType, Boolean>(TeleportationType.class);
    private double lastTeleportDistance;
    private TeleportationType lastTeleportationType;
    private boolean tracked = false;

    public RiftStabilizerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.RIFT_STABILIZER_BLOCK_ENTITY.get(), pos, state);
        this.setDefaultFilters(this);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!this.tracked) {
            BlockEntityTracker.RIFT_STABILIZER.track(this);
            this.tracked = true;
        }
    }

    @Override
    public void setRemoved() {
        super.setRemoved();
        BlockEntityTracker.RIFT_STABILIZER.stopTracking(this);
    }

    @Override
    public void setFilter(TeleportationType teleportationType, boolean allowed) {
        if (this.teleportationFilter.containsKey((Object)teleportationType)) {
            RiftStabilizerBlockEntity connectedBlockEntity;
            this.teleportationFilter.put(teleportationType, allowed);
            this.setChanged();
            if (this.level.isClientSide()) {
                ClientPacketDistributor.sendToServer((CustomPacketPayload)new SyncRiftStabilizer(this.worldPosition, teleportationType, allowed), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if ((connectedBlockEntity = RiftStabilizerBlock.getConnectedBlockEntity(this.level, this.worldPosition)) != null) {
                connectedBlockEntity.teleportationFilter.put(teleportationType, allowed);
                connectedBlockEntity.setChanged();
            }
        }
    }

    @Override
    public boolean getFilter(TeleportationType teleportationType) {
        return this.teleportationFilter.containsKey((Object)teleportationType) && this.teleportationFilter.get((Object)teleportationType) != false;
    }

    @Override
    public ToIntFunction<TeleportationType> getComparatorOutputFunction() {
        return t -> t.ordinal() + 1;
    }

    @Override
    public Map<TeleportationType, Boolean> getFilters() {
        return this.teleportationFilter;
    }

    @Override
    public TeleportationType getDefaultType() {
        return TeleportationType.MODDED;
    }

    @Override
    public void saveAdditional(ValueOutput tag) {
        super.saveAdditional(tag);
        ValueOutput teleportationNBT = tag.child("teleportationTypes");
        int i = 0;
        for (boolean b : this.teleportationFilter.values()) {
            teleportationNBT.putBoolean("teleportationType" + i, b);
            ++i;
        }
        tag.putDouble("lastTeleportDistance", this.lastTeleportDistance);
        if (this.lastTeleportationType != null) {
            tag.putInt("lastTeleportationType", this.lastTeleportationType.ordinal());
        }
    }

    @Override
    public void loadAdditional(ValueInput tag) {
        super.loadAdditional(tag);
        ValueInput teleportationNBT = tag.childOrEmpty("teleportationTypes");
        int i = 0;
        for (TeleportationType teleportationType : this.teleportationFilter.keySet()) {
            this.teleportationFilter.put(teleportationType, teleportationNBT.getBooleanOr("teleportationType" + i, this.teleportationFilter.get((Object)teleportationType).booleanValue()));
            ++i;
        }
        this.lastTeleportDistance = tag.getDoubleOr("lastTeleportDistance", 0.0);
        if (tag.getInt("lastTeleportationType").isPresent()) {
            this.lastTeleportationType = TeleportationType.values()[tag.getIntOr("lastTeleportationType", 0)];
        }
    }

    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleInserted(stack, module, toggled);
        RiftStabilizerBlockEntity connectedBlockEntity = RiftStabilizerBlock.getConnectedBlockEntity(this.level, this.worldPosition);
        if (connectedBlockEntity != null && (toggled ? !connectedBlockEntity.isModuleEnabled(module) : !connectedBlockEntity.hasModule(module))) {
            connectedBlockEntity.insertModule(stack, toggled);
        }
        if (module == ModuleType.DISGUISE) {
            this.onInsertDisguiseModule(this, stack);
            if (connectedBlockEntity != null) {
                this.onInsertDisguiseModule(connectedBlockEntity, stack);
            }
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        RiftStabilizerBlockEntity connectedBlockEntity = RiftStabilizerBlock.getConnectedBlockEntity(this.level, this.worldPosition);
        if (connectedBlockEntity != null && (toggled ? connectedBlockEntity.isModuleEnabled(module) : connectedBlockEntity.hasModule(module))) {
            connectedBlockEntity.removeModule(module, toggled);
        }
        if (module == ModuleType.DISGUISE) {
            this.onRemoveDisguiseModule(this);
            if (connectedBlockEntity != null) {
                this.onRemoveDisguiseModule(connectedBlockEntity);
            }
        } else if (module == ModuleType.SMART) {
            this.setDefaultFilters(this);
            if (connectedBlockEntity != null) {
                this.setDefaultFilters(connectedBlockEntity);
            }
        }
    }

    private void onInsertDisguiseModule(BlockEntity be, ItemStack stack) {
        if (!be.getLevel().isClientSide()) {
            be.getLevel().sendBlockUpdated(be.getBlockPos(), be.getBlockState(), be.getBlockState(), 3);
        } else {
            ClientHandler.putDisguisedBeRenderer(be, stack);
        }
    }

    private void onRemoveDisguiseModule(BlockEntity be) {
        if (!be.getLevel().isClientSide()) {
            be.getLevel().sendBlockUpdated(be.getBlockPos(), be.getBlockState(), be.getBlockState(), 3);
        } else {
            ClientHandler.DISGUISED_BLOCK_RENDER_DELEGATE.removeDelegateOf(be);
        }
    }

    private void setDefaultFilters(RiftStabilizerBlockEntity be) {
        be.teleportationFilter.put(TeleportationType.ITEM_CONSUMPTION, true);
        be.teleportationFilter.put(TeleportationType.ENDER_PEARL, true);
        be.teleportationFilter.put(TeleportationType.ENDERMAN, false);
        be.teleportationFilter.put(TeleportationType.SHULKER, false);
        be.teleportationFilter.put(TeleportationType.MODDED, false);
    }

    public void setLastTeleport(double teleportDistance, TeleportationType type) {
        this.lastTeleportDistance = teleportDistance;
        this.lastTeleportationType = type;
    }

    public double getLastTeleportDistance() {
        return this.lastTeleportDistance;
    }

    public TeleportationType getLastTeleportationType() {
        return this.lastTeleportationType;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DISGUISE, ModuleType.REDSTONE, ModuleType.HARMING, ModuleType.SMART};
    }

    @Override
    public <T> void onOptionChanged(Option<T> option) {
        RiftStabilizerBlockEntity connectedBlockEntity = RiftStabilizerBlock.getConnectedBlockEntity(this.level, this.worldPosition);
        if (connectedBlockEntity != null) {
            Option<T> option2 = option;
            Objects.requireNonNull(option2);
            Option<T> option3 = option2;
            int n = 0;
            block6: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Option.IntOption.class, Option.IntOption.class, Option.BooleanOption.class, Option.BooleanOption.class}, option3, n)) {
                    case 0: {
                        Option.IntOption io = (Option.IntOption)option3;
                        if (option != this.signalLength) {
                            n = 1;
                            continue block6;
                        }
                        connectedBlockEntity.setSignalLength((Integer)io.get());
                        break block6;
                    }
                    case 1: {
                        Option.IntOption io = (Option.IntOption)option3;
                        if (option != this.range) {
                            n = 2;
                            continue block6;
                        }
                        connectedBlockEntity.setRange((Integer)io.get());
                        break block6;
                    }
                    case 2: {
                        Option.BooleanOption bo = (Option.BooleanOption)option3;
                        if (option != this.disabled) {
                            n = 3;
                            continue block6;
                        }
                        connectedBlockEntity.setDisabled((Boolean)bo.get());
                        break block6;
                    }
                    case 3: {
                        Option.BooleanOption bo = (Option.BooleanOption)option3;
                        if (option != this.ignoreOwner) {
                            n = 4;
                            continue block6;
                        }
                        connectedBlockEntity.setIgnoresOwner((Boolean)bo.get());
                        break block6;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unhandled option synchronization in rift stabilizer! " + option.getName());
                    }
                }
                break;
            }
        }
        super.onOptionChanged(option);
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.signalLength, this.range, this.disabled, this.ignoreOwner};
    }

    @Override
    public void onOwnerChanged(BlockState state, Level level, BlockPos pos, Player player, Owner oldOwner, Owner newOwner) {
        RiftStabilizerBlockEntity be = RiftStabilizerBlock.getConnectedBlockEntity(level, pos);
        if (be != null) {
            be.setOwner(this.getOwner().getUUID(), this.getOwner().getName());
            if (!level.isClientSide()) {
                level.getServer().getPlayerList().broadcastAll((Packet)be.getUpdatePacket());
            }
        }
        super.onOwnerChanged(state, level, pos, player, oldOwner, newOwner);
    }

    public void setSignalLength(int signalLength) {
        if (this.getSignalLength() != signalLength) {
            this.signalLength.setValue(signalLength);
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false)));
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            this.setChanged();
        }
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    public void setRange(int range) {
        if (this.getRange() != range) {
            this.range.setValue(range);
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            this.setChanged();
        }
    }

    public int getRange() {
        return (Integer)this.range.get();
    }

    public void setDisabled(boolean disabled) {
        if (this.isDisabled() != disabled) {
            this.disabled.setValue(disabled);
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            this.setChanged();
        }
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    public void setIgnoresOwner(boolean ignoresOwner) {
        if (this.ignoresOwner() != ignoresOwner) {
            this.ignoreOwner.setValue(ignoresOwner);
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            this.setChanged();
        }
    }

    @Override
    public boolean ignoresOwner() {
        return (Boolean)this.ignoreOwner.get();
    }

    @Override
    public void setCustomName(Component customName) {
        super.setCustomName(customName);
        if (this.getBlockState().getValue((Property)BlockStateProperties.DOUBLE_BLOCK_HALF) == DoubleBlockHalf.LOWER) {
            ((NamedBlockEntity)this.level.getBlockEntity(this.worldPosition.above())).setCustomName(customName);
        }
    }

    public static enum TeleportationType {
        ITEM_CONSUMPTION("gui.securitycraft:rift_stabilizer.item_consumption"),
        ENDER_PEARL(Items.ENDER_PEARL.getDescriptionId()),
        ENDERMAN(EntityType.ENDERMAN.getDescriptionId()),
        SHULKER(EntityType.SHULKER.getDescriptionId()),
        MODDED("gui.securitycraft:rift_stabilizer.modded");

        public final String label;

        private TeleportationType(String label) {
            this.label = label;
        }

        public static TeleportationType getTypeFromEvent(EntityTeleportEvent event) {
            TeleportationType teleportationType;
            EntityTeleportEvent entityTeleportEvent = event;
            Objects.requireNonNull(entityTeleportEvent);
            EntityTeleportEvent entityTeleportEvent2 = entityTeleportEvent;
            int n = 0;
            block9: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EntityTeleportEvent.ItemConsumption.class, EntityTeleportEvent.EnderPearl.class, EntityTeleportEvent.EnderEntity.class, EntityTeleportEvent.EnderEntity.class, EntityTeleportEvent.EnderEntity.class, EntityTeleportEvent.TeleportCommand.class, EntityTeleportEvent.SpreadPlayersCommand.class}, (Object)entityTeleportEvent2, n)) {
                    case 0: {
                        EntityTeleportEvent.ItemConsumption fruit = (EntityTeleportEvent.ItemConsumption)entityTeleportEvent2;
                        teleportationType = ITEM_CONSUMPTION;
                        break block9;
                    }
                    case 1: {
                        EntityTeleportEvent.EnderPearl pearl = (EntityTeleportEvent.EnderPearl)entityTeleportEvent2;
                        teleportationType = ENDER_PEARL;
                        break block9;
                    }
                    case 2: {
                        EntityTeleportEvent.EnderEntity ender = (EntityTeleportEvent.EnderEntity)entityTeleportEvent2;
                        if (!(ender.getEntityLiving() instanceof EnderMan)) {
                            n = 3;
                            continue block9;
                        }
                        teleportationType = ENDERMAN;
                        break block9;
                    }
                    case 3: {
                        EntityTeleportEvent.EnderEntity ender = (EntityTeleportEvent.EnderEntity)entityTeleportEvent2;
                        if (!(ender.getEntityLiving() instanceof Shulker)) {
                            n = 4;
                            continue block9;
                        }
                        teleportationType = SHULKER;
                        break block9;
                    }
                    case 4: {
                        EntityTeleportEvent.EnderEntity ender = (EntityTeleportEvent.EnderEntity)entityTeleportEvent2;
                        teleportationType = MODDED;
                        break block9;
                    }
                    case 5: {
                        EntityTeleportEvent.TeleportCommand teleport = (EntityTeleportEvent.TeleportCommand)entityTeleportEvent2;
                        teleportationType = null;
                        break block9;
                    }
                    case 6: {
                        EntityTeleportEvent.SpreadPlayersCommand spreadPlayers = (EntityTeleportEvent.SpreadPlayersCommand)entityTeleportEvent2;
                        teleportationType = null;
                        break block9;
                    }
                    default: {
                        teleportationType = MODDED;
                        break block9;
                    }
                }
                break;
            }
            return teleportationType;
        }

        public String toString() {
            return this.label;
        }
    }
}

