/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ICodebreakable;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.components.CodebreakerData;
import net.geforcemods.securitycraft.components.KeycardData;
import net.geforcemods.securitycraft.components.OwnerData;
import net.geforcemods.securitycraft.inventory.ItemContainer;
import net.geforcemods.securitycraft.inventory.KeycardReaderMenu;
import net.geforcemods.securitycraft.items.CodebreakerItem;
import net.geforcemods.securitycraft.items.KeycardItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.TeamUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class KeycardReaderBlockEntity
extends DisguisableBlockEntity
implements MenuProvider,
ILockable,
ICodebreakable {
    protected boolean[] acceptedLevels = new boolean[]{true, false, false, false, false};
    protected int signature = 0;
    protected Option.BooleanOption sendDenylistMessage = new Option.SendDenylistMessageOption(true);
    protected Option.IntOption signalLength = new Option.SignalLengthOption(60);
    protected Option.DisabledOption disabled = new Option.DisabledOption(false);

    public KeycardReaderBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)SCContent.KEYCARD_READER_BLOCK_ENTITY.get(), pos, state);
    }

    public KeycardReaderBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void saveAdditional(ValueOutput tag) {
        super.saveAdditional(tag);
        ValueOutput acceptedLevelsTag = tag.child("acceptedLevels");
        for (int i = 1; i <= 5; ++i) {
            acceptedLevelsTag.putBoolean("lvl" + i, this.acceptedLevels[i - 1]);
        }
        tag.putInt("signature", this.signature);
    }

    @Override
    public void loadAdditional(ValueInput tag) {
        super.loadAdditional(tag);
        if (tag.getInt("passLV").isPresent()) {
            boolean oldRequiresExactKeycard = false;
            int oldPassLV = tag.getIntOr("passLV", 0) - 1;
            oldRequiresExactKeycard = tag.getBooleanOr("requiresExactKeycard", false);
            for (int i = 0; i < 5; ++i) {
                this.acceptedLevels[i] = oldRequiresExactKeycard ? i == oldPassLV : i >= oldPassLV;
            }
        }
        if (tag.child("acceptedLevels").isPresent()) {
            ValueInput acceptedLevelsTag = tag.childOrEmpty("acceptedLevels");
            for (int i = 1; i <= 5; ++i) {
                this.acceptedLevels[i - 1] = acceptedLevelsTag.getBooleanOr("lvl" + i, false);
            }
        }
        this.signature = tag.getIntOr("signature", 0);
        this.sendDenylistMessage.setValue(tag.getBooleanOr("sendMessage", this.sendsDenylistMessage()));
    }

    @Override
    public boolean shouldAttemptCodebreak(Player player) {
        if (this.isDisabled()) {
            player.displayClientMessage((Component)Utils.localize("gui.securitycraft:scManual.disabled", new Object[0]), true);
            return false;
        }
        return (Boolean)this.getBlockState().getValue((Property)BlockStateProperties.POWERED) == false;
    }

    @Override
    public void useCodebreaker(Player player) {
        if (!this.level.isClientSide()) {
            this.activate();
        }
    }

    public InteractionResult onRightClickWithActionItem(ItemStack stack, InteractionHand hand, Player player, boolean isCodebreaker, boolean isKeycardHolder) {
        if (isCodebreaker) {
            double chance = CodebreakerItem.getSuccessChance(stack);
            if (chance < 0.0) {
                PlayerUtils.sendMessageToPlayer(player, Utils.localize(this.getBlockState().getBlock().getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:codebreakerDisabled", new Object[0]), ChatFormatting.RED);
            } else {
                if (!player.isCreative() && (this.isOwnedBy((Entity)player) || ((CodebreakerData)stack.getOrDefault(SCContent.CODEBREAKER_DATA, (Object)CodebreakerData.DEFAULT)).wasRecentlyUsed())) {
                    return InteractionResult.TRY_WITH_EMPTY_HAND;
                }
                boolean isSuccessful = player.isCreative() || SecurityCraft.RANDOM.nextDouble() < chance;
                stack.hurtAndBreak(1, (LivingEntity)player, hand.asEquipmentSlot());
                stack.set(SCContent.CODEBREAKER_DATA, (Object)new CodebreakerData(System.currentTimeMillis(), isSuccessful));
                if (isSuccessful) {
                    this.activate();
                } else {
                    PlayerUtils.sendMessageToPlayer(player, Utils.localize(((CodebreakerItem)((Object)SCContent.CODEBREAKER.get())).getDescriptionId(), new Object[0]), Utils.localize("messages.securitycraft:codebreaker.failed", new Object[0]), ChatFormatting.RED);
                }
            }
        } else if (isKeycardHolder) {
            ItemContainer holderInventory = ItemContainer.keycardHolder(stack);
            MutableComponent feedback = null;
            for (int i = 0; i < holderInventory.getContainerSize(); ++i) {
                ItemStack keycardStack = holderInventory.getItem(i);
                if (!(keycardStack.getItem() instanceof KeycardItem) || !keycardStack.has(SCContent.KEYCARD_DATA) || (feedback = this.insertCard(keycardStack, player)) != null) continue;
                holderInventory.save();
                return InteractionResult.SUCCESS;
            }
            if (feedback == null) {
                PlayerUtils.sendMessageToPlayer(player, Component.translatable((String)this.getBlockState().getBlock().getDescriptionId()), Utils.localize("messages.securitycraft:keycard_holder.no_keycards", new Object[0]), ChatFormatting.RED);
            } else {
                PlayerUtils.sendMessageToPlayer(player, Component.translatable((String)this.getBlockState().getBlock().getDescriptionId()), Utils.localize("messages.securitycraft:keycard_holder.fail", new Object[0]), ChatFormatting.RED);
            }
        } else {
            MutableComponent feedback = this.insertCard(stack, player);
            if (feedback != null) {
                PlayerUtils.sendMessageToPlayer(player, Component.translatable((String)this.getBlockState().getBlock().getDescriptionId()), feedback, ChatFormatting.RED);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public MutableComponent insertCard(ItemStack stack, Player player) {
        boolean powered;
        Owner keycardOwner = ((OwnerData)stack.getOrDefault(SCContent.OWNER_DATA, (Object)OwnerData.DEFAULT)).toOwner();
        if (!TeamUtils.areOnSameTeam(this.getOwner(), keycardOwner) || !this.getOwner().getUUID().equals(keycardOwner.getUUID())) {
            return Component.translatable((String)"messages.securitycraft:keycardReader.differentOwner");
        }
        KeycardData keycardData = (KeycardData)stack.getOrDefault(SCContent.KEYCARD_DATA, (Object)KeycardData.DEFAULT);
        if (!keycardData.usableBy().map(player.getGameProfile().name()::equals).orElse(true).booleanValue()) {
            return Component.translatable((String)"messages.securitycraft:keycardReader.cantUse");
        }
        if (this.getSignature() != keycardData.signature()) {
            return Component.translatable((String)"messages.securitycraft:keycardReader.wrongSignature");
        }
        int keycardLevel = ((KeycardItem)stack.getItem()).getLevel();
        if (!this.getAcceptedLevels()[keycardLevel]) {
            return Component.translatable((String)"messages.securitycraft:keycardReader.wrongLevel", (Object[])new Object[]{keycardLevel + 1});
        }
        boolean bl = powered = (Boolean)this.level.getBlockState(this.worldPosition).getValue((Property)BlockStateProperties.POWERED) != false && this.getSignalLength() > 0;
        if (!powered) {
            if (keycardData.limited()) {
                int usesLeft = keycardData.usesLeft();
                if (usesLeft <= 0) {
                    return Component.translatable((String)"messages.securitycraft:keycardReader.noUses");
                }
                if (!player.isCreative()) {
                    stack.set(SCContent.KEYCARD_DATA, (Object)keycardData.setUsesLeft(--usesLeft));
                }
            }
            this.activate();
        }
        return null;
    }

    public void activate() {
        Block block = this.getBlockState().getBlock();
        int signalLength = this.getSignalLength();
        this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().cycle((Property)BlockStateProperties.POWERED));
        BlockUtils.updateIndirectNeighbors(this.level, this.worldPosition, block);
        if (signalLength > 0) {
            this.level.scheduleTick(this.worldPosition, block, signalLength);
        }
    }

    public void writeClientSideData(AbstractContainerMenu menu, RegistryFriendlyByteBuf buffer) {
        super.writeClientSideData(menu, buffer);
        buffer.writeBlockPos(this.worldPosition);
    }

    @Override
    public <T> void onOptionChanged(Option<T> option) {
        if (option == this.signalLength) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false)));
            BlockUtils.updateIndirectNeighbors(this.level, this.worldPosition, this.getBlockState().getBlock());
        }
        super.onOptionChanged(option);
    }

    public void setAcceptedLevels(boolean[] acceptedLevels) {
        this.acceptedLevels = acceptedLevels;
        this.setChanged();
    }

    public boolean[] getAcceptedLevels() {
        return this.acceptedLevels;
    }

    public void setSignature(int signature) {
        this.signature = signature;
        this.setChanged();
    }

    public int getSignature() {
        return this.signature;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST, ModuleType.DISGUISE, ModuleType.SMART};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendDenylistMessage, this.signalLength, this.disabled};
    }

    public boolean sendsDenylistMessage() {
        return (Boolean)this.sendDenylistMessage.get();
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory inv, Player player) {
        return new KeycardReaderMenu(windowId, inv, this.level, this.worldPosition);
    }

    @Override
    public void onOwnerChanged(BlockState state, Level level, BlockPos pos, Player player, Owner oldOwner, Owner newOwner) {
        this.reset();
        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BlockStateProperties.POWERED, (Comparable)Boolean.valueOf(false)));
        BlockUtils.updateIndirectNeighbors(level, pos, state.getBlock());
        super.onOwnerChanged(state, level, pos, player, oldOwner, newOwner);
    }

    public void reset() {
        this.acceptedLevels = new boolean[]{true, false, false, false, false};
        this.signature = 0;
        this.setChanged();
    }

    public Component getDisplayName() {
        return super.getDisplayName();
    }
}

