/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.OwnableBlockEntity;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class NamedBlockEntity
extends OwnableBlockEntity
implements Nameable {
    private Component customName;

    public NamedBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)SCContent.ABSTRACT_BLOCK_ENTITY.get(), pos, state);
    }

    public NamedBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void saveAdditional(ValueOutput tag) {
        super.saveAdditional(tag);
        tag.storeNullable("CustomName", ComponentSerialization.CODEC, (Object)this.customName);
    }

    @Override
    public void loadAdditional(ValueInput tag) {
        super.loadAdditional(tag);
        this.customName = NamedBlockEntity.parseCustomNameSafe((ValueInput)tag, (String)"CustomName");
    }

    public Component getName() {
        return this.hasCustomName() ? this.getCustomName() : this.getDefaultName();
    }

    public boolean hasCustomName() {
        Component name = this.getCustomName();
        return name != null && !Component.empty().equals((Object)name) && !this.getDefaultName().equals((Object)name);
    }

    public Component getCustomName() {
        return this.customName;
    }

    public void setCustomName(Component customName) {
        this.customName = customName;
        this.setChanged();
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
    }

    public Component getDefaultName() {
        return Utils.localize(this.getBlockState().getBlock().getDescriptionId(), new Object[0]);
    }

    protected void applyImplicitComponents(DataComponentGetter input) {
        super.applyImplicitComponents(input);
        this.customName = (Component)input.get(DataComponents.CUSTOM_NAME);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(DataComponents.CUSTOM_NAME, (Object)this.customName);
    }

    public void removeComponentsFromTag(ValueOutput tag) {
        tag.discard("CustomName");
        tag.discard("customName");
    }
}

