/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.misc.TargetingMode;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public interface IExplosive {
    public void explode(Level var1, BlockPos var2);

    public boolean activateMine(Level var1, BlockPos var2);

    public boolean defuseMine(Level var1, BlockPos var2);

    public boolean isActive(Level var1, BlockPos var2);

    public boolean isDefusable();

    public boolean explodesWhenInteractedWith();

    default public InteractionResult exUseItemOn(ItemStack heldItem, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (heldItem.is((Item)SCContent.MINE_REMOTE_ACCESS_TOOL.get())) {
            return InteractionResult.SUCCESS;
        }
        if (heldItem.getItem() == SCContent.WIRE_CUTTERS.get() && this.isActive(level, pos) && this.isDefusable()) {
            if (this.defuseMine(level, pos)) {
                if (!player.isCreative()) {
                    player.getItemInHand(hand).hurtAndBreak(1, (LivingEntity)player, hand.asEquipmentSlot());
                }
                level.playSound(null, pos, SoundEvents.SHEEP_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        if (heldItem.is(Items.FLINT_AND_STEEL) && !this.isActive(level, pos) && this.activateMine(level, pos)) {
            if (!player.isCreative()) {
                player.getItemInHand(hand).hurtAndBreak(1, (LivingEntity)player, hand.asEquipmentSlot());
            }
            level.playSound(null, pos, SoundEvents.TRIPWIRE_CLICK_ON, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    default public InteractionResult exUseWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (this.explodesWhenInteractedWith() && this.isActive(level, pos)) {
            BlockEntity be = level.getBlockEntity(pos);
            Option<?>[] optionArray = level.getBlockEntity(pos);
            if (optionArray instanceof ICustomizable) {
                ICustomizable mine = (ICustomizable)optionArray;
                for (Option<Object> option : mine.customOptions()) {
                    Option.TargetingModeOption targetingMode;
                    if (option instanceof Option.EntityDataWrappedOption) {
                        Option.EntityDataWrappedOption wrapped = (Option.EntityDataWrappedOption)option;
                        option = wrapped.getWrapped();
                    }
                    if (option instanceof Option.TargetingModeOption && !((TargetingMode)((Object)(targetingMode = (Option.TargetingModeOption)option).get())).allowsPlayers()) {
                        return InteractionResult.PASS;
                    }
                    if (!(option instanceof Option.IgnoreOwnerOption)) continue;
                    Option.IgnoreOwnerOption ignoreOwner = (Option.IgnoreOwnerOption)option;
                    if (!((IOwnable)be).isOwnedBy((Entity)player) || !((Boolean)ignoreOwner.get()).booleanValue()) continue;
                    return InteractionResult.PASS;
                }
            }
            this.explode(level, pos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

