/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import net.geforcemods.securitycraft.api.Option;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public interface ICustomizable {
    public Option<?>[] customOptions();

    default public <T> void onOptionChanged(Option<T> option) {
        ICustomizable iCustomizable = this;
        if (iCustomizable instanceof BlockEntity) {
            BlockEntity be = (BlockEntity)iCustomizable;
            be.setChanged();
        }
    }

    default public void readOptions(ValueInput tag) {
        Option<?>[] customOptions = this.customOptions();
        if (customOptions.length > 0) {
            for (Option<?> option : customOptions) {
                option.load(tag);
            }
        }
    }

    default public void writeOptions(ValueOutput tag) {
        Option<?>[] customOptions = this.customOptions();
        if (customOptions.length > 0) {
            for (Option<?> option : customOptions) {
                option.save(tag);
            }
        }
    }
}

