/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils.world.inventory;

import fuzs.easyanvils.EasyAnvils;
import fuzs.easyanvils.config.RenameAndRepairCost;
import fuzs.easyanvils.config.ServerConfig;
import fuzs.easyanvils.init.ModRegistry;
import fuzs.easyanvils.services.CommonAbstractions;
import fuzs.easyanvils.util.ComponentDecomposer;
import fuzs.easyanvils.util.FormattedStringDecomposer;
import fuzs.easyanvils.world.inventory.state.AnvilMenuState;
import fuzs.easyanvils.world.inventory.state.BuiltInAnvilMenu;
import fuzs.easyanvils.world.level.block.entity.AnvilBlockEntity;
import fuzs.puzzleslib.api.container.v1.QuickMoveRuleSet;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public abstract class ModAnvilMenu
extends AnvilMenu {
    private final Container container;
    private final AnvilMenuState builtInAnvilState;
    private final AnvilMenuState vanillaAnvilState;

    public ModAnvilMenu(int id, Inventory inventory) {
        super(id, inventory);
        this.container = new SimpleContainer(new ItemStack[0]);
        this.builtInAnvilState = new BuiltInAnvilMenu(inventory, ContainerLevelAccess.NULL);
        this.vanillaAnvilState = CommonAbstractions.INSTANCE.createVanillaAnvilMenu(inventory, ContainerLevelAccess.NULL);
        this.createResult();
    }

    public ModAnvilMenu(int id, Inventory inventory, AnvilBlockEntity blockEntity, ContainerLevelAccess containerLevelAccess) {
        super(id, inventory, containerLevelAccess);
        this.container = blockEntity;
        this.builtInAnvilState = new BuiltInAnvilMenu(inventory, containerLevelAccess);
        this.vanillaAnvilState = CommonAbstractions.INSTANCE.createVanillaAnvilMenu(inventory, containerLevelAccess);
        this.initializeSlots(blockEntity);
        this.createResult();
    }

    private void initializeSlots(AnvilBlockEntity blockEntity) {
        ((SimpleContainer)this.inputSlots).items = blockEntity.getItems();
        ((SimpleContainer)this.inputSlots).addListener(container -> blockEntity.setChanged());
        this.resultSlots.itemStacks = blockEntity.getResult();
    }

    public MenuType<?> getType() {
        return (MenuType)ModRegistry.ANVIL_MENU_TYPE.value();
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    protected boolean mayPickup(Player player, boolean hasStack) {
        return (player.getAbilities().instabuild || player.experienceLevel >= this.getCost()) && this.getCost() >= 0;
    }

    protected final void createAnvilResult() {
        if (this.builtInAnvilState == null || this.vanillaAnvilState == null) {
            return;
        }
        ItemStack primaryItemStack = this.inputSlots.getItem(0);
        ItemStack secondaryItemStack = this.inputSlots.getItem(1);
        this.builtInAnvilState.init(primaryItemStack, secondaryItemStack, this.itemName);
        this.vanillaAnvilState.init(primaryItemStack, secondaryItemStack, this.itemName);
        this.builtInAnvilState.fillResultSlots();
        this.vanillaAnvilState.fillResultSlots();
        if (!AnvilMenuState.equals(this.builtInAnvilState, this.vanillaAnvilState)) {
            super.createResult();
        } else {
            this.createAnvilResult(primaryItemStack, secondaryItemStack, this.itemName);
        }
    }

    private void createAnvilResult(ItemStack primaryItemStack, ItemStack secondaryItemStack, String itemName) {
        this.setCost(1);
        if (primaryItemStack.isEmpty() || !EnchantmentHelper.canStoreEnchantments((ItemStack)primaryItemStack)) {
            this.resultSlots.setItem(0, ItemStack.EMPTY);
            this.setCost(0);
        } else {
            int maxAnvilRepairCost;
            boolean hasNoLimit;
            int allOperationsCost;
            ItemStack output = primaryItemStack.copy();
            ItemEnchantments.Mutable leftEnchantments = new ItemEnchantments.Mutable(EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)output));
            int baseRepairCost = (Integer)primaryItemStack.getOrDefault(DataComponents.REPAIR_COST, (Object)0) + (secondaryItemStack.isEmpty() ? 0 : (Integer)secondaryItemStack.getOrDefault(DataComponents.REPAIR_COST, (Object)0));
            baseRepairCost = ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).priorWorkPenalty.priorWorkPenalty.operator.applyAsInt(baseRepairCost);
            this.repairItemCountCost = 0;
            boolean isBook = false;
            int repairOperationCost = 0;
            int enchantOperationCost = 0;
            int renameOperationCost = 0;
            if (!secondaryItemStack.isEmpty()) {
                isBook = secondaryItemStack.has(DataComponents.STORED_ENCHANTMENTS);
                if (output.isDamageableItem() && output.isValidRepairItem(secondaryItemStack)) {
                    int repairMaterials;
                    int l2 = (int)Math.min((double)output.getDamageValue(), Math.floor((double)output.getMaxDamage() * ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.repairWithMaterialRestoredDurability));
                    if (l2 <= 0) {
                        this.resultSlots.setItem(0, ItemStack.EMPTY);
                        this.setCost(0);
                        return;
                    }
                    for (repairMaterials = 0; l2 > 0 && repairMaterials < secondaryItemStack.getCount(); ++repairMaterials) {
                        int j3 = output.getDamageValue() - l2;
                        output.setDamageValue(j3);
                        repairOperationCost += ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.repairWithMaterialUnitCost;
                        l2 = (int)Math.min((double)output.getDamageValue(), Math.floor((double)output.getMaxDamage() * ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.repairWithMaterialRestoredDurability));
                    }
                    this.repairItemCountCost = repairMaterials;
                } else {
                    if (!(isBook || output.is(secondaryItemStack.getItem()) && output.isDamageableItem())) {
                        this.resultSlots.setItem(0, ItemStack.EMPTY);
                        this.setCost(0);
                        return;
                    }
                    if (output.isDamageableItem() && !isBook) {
                        int l = primaryItemStack.getMaxDamage() - primaryItemStack.getDamageValue();
                        int i1 = secondaryItemStack.getMaxDamage() - secondaryItemStack.getDamageValue();
                        int j1 = i1 + (int)Math.floor((double)output.getMaxDamage() * ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.repairWithOtherItemBonusDurability);
                        int k1 = l + j1;
                        int l1 = output.getMaxDamage() - k1;
                        if (l1 < 0) {
                            l1 = 0;
                        }
                        if (l1 < output.getDamageValue()) {
                            output.setDamageValue(l1);
                            repairOperationCost += ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.repairWithOtherItemCost;
                        }
                    }
                    ItemEnchantments rightEnchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)secondaryItemStack);
                    boolean itemWithCompatibleEnchantment = false;
                    boolean itemWithIncompatibleEnchantment = false;
                    for (Holder rightHolder : rightEnchantments.keySet()) {
                        int enchantmentLevel;
                        Enchantment rightEnchantment = (Enchantment)rightHolder.value();
                        int leftEnchantmentLevel = leftEnchantments.getLevel(rightHolder);
                        enchantmentLevel = leftEnchantmentLevel == (enchantmentLevel = rightEnchantments.getLevel(rightHolder)) ? enchantmentLevel + 1 : Math.max(enchantmentLevel, leftEnchantmentLevel);
                        boolean compatibleWithItem = rightEnchantment.canEnchant(primaryItemStack);
                        if (this.player.getAbilities().instabuild || primaryItemStack.is(Items.ENCHANTED_BOOK)) {
                            compatibleWithItem = true;
                        }
                        for (Holder leftHolder : leftEnchantments.keySet()) {
                            if (leftHolder.equals((Object)rightHolder) || Enchantment.areCompatible((Holder)rightHolder, (Holder)leftHolder)) continue;
                            compatibleWithItem = false;
                            ++enchantOperationCost;
                        }
                        if (!compatibleWithItem) {
                            if (repairOperationCost > 0) continue;
                            itemWithIncompatibleEnchantment = true;
                            continue;
                        }
                        itemWithCompatibleEnchantment = true;
                        if (enchantmentLevel > rightEnchantment.getMaxLevel()) {
                            enchantmentLevel = rightEnchantment.getMaxLevel();
                        }
                        int maxLevel = Math.max(leftEnchantments.getLevel(rightHolder), rightEnchantments.getLevel(rightHolder));
                        if ((maxLevel = Math.max(maxLevel, enchantmentLevel)) != enchantmentLevel) {
                            enchantmentLevel = maxLevel;
                        }
                        int rarityCostMultiplier = rightEnchantment.getAnvilCost();
                        if (isBook && ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.halvedBookCosts) {
                            rarityCostMultiplier = Math.max(1, rarityCostMultiplier / 2);
                        }
                        int oldEnchantmentLevel = leftEnchantments.getLevel(rightHolder);
                        leftEnchantments.set(rightHolder, enchantmentLevel);
                        if (oldEnchantmentLevel != 0 || oldEnchantmentLevel != enchantmentLevel) {
                            enchantOperationCost += rarityCostMultiplier * enchantmentLevel;
                        }
                        if (primaryItemStack.getCount() <= 1 || this.player.getAbilities().instabuild) continue;
                        this.resultSlots.setItem(0, ItemStack.EMPTY);
                        this.setCost(-1);
                        return;
                    }
                    if (itemWithIncompatibleEnchantment && !itemWithCompatibleEnchantment) {
                        this.resultSlots.setItem(0, ItemStack.EMPTY);
                        this.setCost(0);
                        return;
                    }
                }
            }
            boolean hasRenamedItem = false;
            if (ComponentDecomposer.getStringLength(itemName) == 0) {
                if (primaryItemStack.has(DataComponents.CUSTOM_NAME)) {
                    renameOperationCost = ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.freeRenames.filter.test(primaryItemStack) ? 0 : 1;
                    hasRenamedItem = true;
                    output.remove(DataComponents.CUSTOM_NAME);
                }
            } else if (!Objects.equals(ComponentDecomposer.toFormattedComponent(itemName), primaryItemStack.getHoverName())) {
                renameOperationCost = ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.freeRenames.filter.test(primaryItemStack) ? 0 : 1;
                hasRenamedItem = true;
                output.set(DataComponents.CUSTOM_NAME, (Object)ComponentDecomposer.toFormattedComponent(itemName));
            }
            if ((allOperationsCost = enchantOperationCost + repairOperationCost + renameOperationCost) == 0) {
                this.setCost(0);
                if (!hasRenamedItem) {
                    output = ItemStack.EMPTY;
                }
            } else {
                int newCost = enchantOperationCost == 0 && ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).priorWorkPenalty.renameAndRepairCosts == RenameAndRepairCost.FIXED ? allOperationsCost : baseRepairCost + allOperationsCost;
                this.setCost(Mth.clamp((int)newCost, (int)0, (int)Integer.MAX_VALUE));
            }
            if (hasRenamedItem && allOperationsCost == renameOperationCost) {
                this.onlyRenaming = true;
            }
            boolean bl = hasNoLimit = (maxAnvilRepairCost = ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.tooExpensiveLimit) == -1;
            if (hasNoLimit) {
                maxAnvilRepairCost = 40;
            }
            if (this.getCost() >= maxAnvilRepairCost) {
                if (enchantOperationCost == 0 && ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).priorWorkPenalty.renameAndRepairCosts == RenameAndRepairCost.LIMITED) {
                    this.setCost(maxAnvilRepairCost - 1);
                } else if (!hasNoLimit && !this.player.getAbilities().instabuild) {
                    output = ItemStack.EMPTY;
                }
            }
            if (!output.isEmpty()) {
                int outputRepairCost = (Integer)output.getOrDefault(DataComponents.REPAIR_COST, (Object)0);
                if (!secondaryItemStack.isEmpty() && outputRepairCost < (Integer)secondaryItemStack.getOrDefault(DataComponents.REPAIR_COST, (Object)0)) {
                    outputRepairCost = (Integer)secondaryItemStack.getOrDefault(DataComponents.REPAIR_COST, (Object)0);
                }
                if (!(allOperationsCost <= 0 || (enchantOperationCost <= 0 || isBook && primaryItemStack.is(Items.ENCHANTED_BOOK) && ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).priorWorkPenalty.penaltyFreeEnchantsForBooks) && ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).priorWorkPenalty.penaltyFreeRenamesAndRepairs)) {
                    outputRepairCost = AnvilMenu.calculateIncreasedRepairCost((int)outputRepairCost);
                }
                if (outputRepairCost > 0) {
                    output.set(DataComponents.REPAIR_COST, (Object)outputRepairCost);
                }
                EnchantmentHelper.setEnchantments((ItemStack)output, (ItemEnchantments)leftEnchantments.toImmutable());
            }
            this.resultSlots.setItem(0, output);
            this.broadcastChanges();
        }
    }

    public void setCost(int cost) {
        this.setData(0, cost);
    }

    public void removed(Player player) {
        ContainerLevelAccess containerLevelAccess = this.access;
        this.access = ContainerLevelAccess.NULL;
        super.removed(player);
        this.access = containerLevelAccess;
    }

    public boolean setItemName(String newName) {
        if (ComponentDecomposer.getStringLength(newName = FormattedStringDecomposer.filterText(newName)) <= 50 && !Objects.equals(newName, this.itemName)) {
            this.itemName = newName.trim();
            if (this.getSlot(2).hasItem()) {
                ItemStack itemStack = this.getSlot(2).getItem();
                ModAnvilMenu.setFormattedItemName(this.itemName, itemStack);
            }
            this.createResult();
            return true;
        }
        return false;
    }

    public static void setFormattedItemName(String newName, ItemStack itemStack) {
        Component component = ComponentDecomposer.toFormattedComponent(newName);
        if (component.getString().isEmpty()) {
            itemStack.remove(DataComponents.CUSTOM_NAME);
        } else {
            itemStack.set(DataComponents.CUSTOM_NAME, (Object)component);
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        return QuickMoveRuleSet.of((AbstractContainerMenu)this, (x$0, x$1, x$2, x$3) -> this.moveItemStackTo(x$0, x$1, x$2, x$3)).addContainerSlotRule(new int[]{0, 1}).addInventoryRules().addInventoryCompartmentRules().quickMoveStack(player, index);
    }
}

