/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.easyanvils.EasyAnvils;
import fuzs.easyanvils.client.renderer.blockentity.state.AnvilRenderState;
import fuzs.easyanvils.config.ClientConfig;
import fuzs.easyanvils.world.level.block.entity.AnvilBlockEntity;
import java.util.ArrayList;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class AnvilRenderer
implements BlockEntityRenderer<AnvilBlockEntity, AnvilRenderState> {
    private final ItemModelResolver itemModelResolver;

    public AnvilRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelResolver = context.itemModelResolver();
    }

    public AnvilRenderState createRenderState() {
        return new AnvilRenderState();
    }

    public void extractRenderState(AnvilBlockEntity blockEntity, AnvilRenderState renderState, float partialTick, Vec3 cameraPosition, @Nullable ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState((BlockEntity)blockEntity, (BlockEntityRenderState)renderState, partialTick, cameraPosition, breakProgress);
        int position = (int)blockEntity.getBlockPos().asLong();
        renderState.items = new ArrayList<ItemStackRenderState>();
        if (((ClientConfig)EasyAnvils.CONFIG.get(ClientConfig.class)).renderAnvilContents) {
            for (int i = 0; i < blockEntity.getContainerSize(); ++i) {
                ItemStackRenderState itemStackRenderState = new ItemStackRenderState();
                this.itemModelResolver.updateForTopItem(itemStackRenderState, blockEntity.getItem(i), ItemDisplayContext.FIXED, blockEntity.getLevel(), null, position + i);
                renderState.items.add(itemStackRenderState);
            }
        }
        renderState.itemLightCoords = blockEntity.getLevel() != null ? LevelRenderer.getLightColor((BlockAndTintGetter)blockEntity.getLevel(), (BlockPos)blockEntity.getBlockPos().above()) : 0xF000F0;
        renderState.direction = (Direction)blockEntity.getBlockState().getValue((Property)AnvilBlock.FACING);
    }

    public void submit(AnvilRenderState renderState, PoseStack poseStack, SubmitNodeCollector nodeCollector, CameraRenderState cameraRenderState) {
        for (int i = 0; i < renderState.items.size(); ++i) {
            ItemStackRenderState itemStackRenderState = renderState.items.get(i);
            if (itemStackRenderState.isEmpty()) continue;
            poseStack.pushPose();
            poseStack.translate(0.0f, 1.0375f, 0.0f);
            poseStack.mulPose((Quaternionfc)Axis.XN.rotationDegrees(90.0f));
            boolean isMirrored = (renderState.direction.getAxisDirection().getStep() == 1 ? 1 : 0) != i % 2;
            switch (renderState.direction.getAxis()) {
                case X: {
                    if (isMirrored) {
                        poseStack.translate(0.25f, -0.5f, 0.0f);
                        break;
                    }
                    poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(180.0f));
                    poseStack.translate(-0.75f, 0.5f, 0.0f);
                    break;
                }
                case Z: {
                    if (isMirrored) {
                        poseStack.mulPose((Quaternionfc)Axis.ZN.rotationDegrees(90.0f));
                        poseStack.translate(0.25f, 0.5f, 0.0f);
                        break;
                    }
                    poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(90.0f));
                    poseStack.translate(-0.75f, -0.5f, 0.0f);
                }
            }
            poseStack.scale(0.375f, 0.375f, 0.375f);
            itemStackRenderState.submit(poseStack, nodeCollector, renderState.itemLightCoords, OverlayTexture.NO_OVERLAY, 0);
            poseStack.popPose();
        }
    }
}

