/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils.client.gui.screens.inventory;

import fuzs.easyanvils.EasyAnvils;
import fuzs.easyanvils.client.gui.components.FormattableEditBox;
import fuzs.easyanvils.client.gui.components.FormattingGuideWidget;
import fuzs.easyanvils.config.ServerConfig;
import fuzs.easyanvils.network.client.ServerboundRenameItemMessage;
import fuzs.easyanvils.util.ComponentDecomposer;
import fuzs.easyanvils.world.level.block.entity.AnvilBlockEntity;
import fuzs.puzzleslib.api.network.v4.MessageSender;
import fuzs.puzzleslib.api.network.v4.message.Message;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AnvilScreen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ModAnvilScreen
extends AnvilScreen {
    private static final Component TOO_EXPENSIVE_TEXT = Component.translatable((String)"container.repair.expensive");

    public ModAnvilScreen(AnvilMenu anvilMenu, Inventory inventory, Component component) {
        super(anvilMenu, inventory, component);
        this.titleLabelY = 8;
    }

    protected void subInit() {
        this.name = ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).miscellaneous.renamingSupportsFormatting ? new FormattableEditBox(this.font, this.leftPos + 62, this.topPos + 24, 103, 12, (Component)AnvilBlockEntity.REPAIR_COMPONENT) : new EditBox(this.font, this.leftPos + 62, this.topPos + 24, 103, 12, (Component)AnvilBlockEntity.REPAIR_COMPONENT);
        this.name.setCanLoseFocus(false);
        this.name.setTextColor(-1);
        this.name.setTextColorUneditable(-1);
        this.name.setBordered(false);
        this.name.setMaxLength(50);
        this.name.setResponder(this::onNameChanged);
        this.name.setValue("");
        this.addRenderableWidget((GuiEventListener)this.name);
        this.name.setEditable(((AnvilMenu)this.menu).getSlot(0).hasItem());
        if (((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).miscellaneous.renamingSupportsFormatting) {
            this.addRenderableWidget((GuiEventListener)new FormattingGuideWidget(this.leftPos + this.imageWidth - 7, this.topPos + this.titleLabelY, this.font));
        }
    }

    public boolean mouseDragged(MouseButtonEvent mouseButtonEvent, double dragX, double dragY) {
        if (this.getFocused() == this.name && this.isDragging() && mouseButtonEvent.button() == 0) {
            return this.getFocused().mouseDragged(mouseButtonEvent, dragX, dragY);
        }
        return super.mouseDragged(mouseButtonEvent, dragX, dragY);
    }

    private void onNameChanged(String input) {
        Slot slot = ((AnvilMenu)this.menu).getSlot(0);
        if (!slot.hasItem()) {
            return;
        }
        if (!slot.getItem().has(DataComponents.CUSTOM_NAME) && input.equals(slot.getItem().getHoverName().getString())) {
            input = "";
        }
        if (((AnvilMenu)this.menu).setItemName(input)) {
            MessageSender.broadcast((Message)new ServerboundRenameItemMessage(input));
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, -12566464, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, -12566464, false);
        int enchantmentLevelCost = ((AnvilMenu)this.menu).getCost();
        if (enchantmentLevelCost > 0) {
            Component component;
            int textColor = -8323296;
            if (this.isTooExpensive(enchantmentLevelCost)) {
                component = TOO_EXPENSIVE_TEXT;
                textColor = -40864;
            } else if (!((AnvilMenu)this.menu).getSlot(2).hasItem()) {
                component = null;
            } else {
                component = Component.translatable((String)"container.repair.cost", (Object[])new Object[]{enchantmentLevelCost});
                if (!((AnvilMenu)this.menu).getSlot(2).mayPickup((Player)this.minecraft.player)) {
                    textColor = -40864;
                }
            }
            if (component != null) {
                int k = this.imageWidth - 8 - this.font.width((FormattedText)component) - 2;
                guiGraphics.fill(k - 2, 67, this.imageWidth - 8, 79, 0x4F000000);
                guiGraphics.drawString(this.font, component, k, 69, textColor);
            }
        }
    }

    private boolean isTooExpensive(int repairCost) {
        int maxAnvilRepairCost = ((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).costs.tooExpensiveLimit;
        return (maxAnvilRepairCost != -1 && repairCost >= maxAnvilRepairCost || repairCost == -1) && !this.minecraft.player.hasInfiniteMaterials();
    }

    public void slotChanged(AbstractContainerMenu containerToSend, int dataSlotIndex, ItemStack stack) {
        if (dataSlotIndex == 0) {
            this.name.setValue(stack.isEmpty() ? "" : ComponentDecomposer.toFormattedString(stack.getHoverName()));
            this.name.setEditable(!stack.isEmpty());
            this.setFocused((GuiEventListener)this.name);
        }
    }
}

