/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils.client.gui.components;

import fuzs.easyanvils.client.gui.screens.inventory.tooltip.LargeTooltipPositioner;
import fuzs.easyanvils.util.FormattedStringDecomposer;
import fuzs.puzzleslib.api.client.gui.v2.tooltip.TooltipBuilder;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractStringWidget;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.inventory.tooltip.BelowOrAboveWidgetTooltipPositioner;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;

public class FormattingGuideWidget
extends AbstractStringWidget {
    private static final Component QUESTION_MARK_COMPONENT = Component.literal((String)"?");

    public FormattingGuideWidget(int x, int y, Font font) {
        int n = x - font.width((FormattedText)QUESTION_MARK_COMPONENT) * 2;
        int n2 = font.width((FormattedText)QUESTION_MARK_COMPONENT) * 2;
        Objects.requireNonNull(font);
        super(n, y, n2, 9, QUESTION_MARK_COMPONENT, font);
        this.active = true;
        TooltipBuilder tooltipBuilder = TooltipBuilder.create().setTooltipPositionerFactory((clientTooltipPositioner, abstractWidget) -> {
            if (clientTooltipPositioner instanceof BelowOrAboveWidgetTooltipPositioner) {
                return new LargeTooltipPositioner(abstractWidget.getRectangle());
            }
            return new LargeTooltipPositioner(null);
        }).setTooltipLineProcessor(tooltipLines -> tooltipLines.stream().map(FormattingGuideWidget::getVisualOrder).toList());
        for (ChatFormatting chatFormatting : ChatFormatting.values()) {
            MutableComponent component = Component.translatable((String)("chat.formatting." + chatFormatting.getName()));
            if (chatFormatting != ChatFormatting.BLACK && chatFormatting != ChatFormatting.OBFUSCATED) {
                component.withStyle(chatFormatting);
            }
            tooltipBuilder.addLines(new FormattedText[]{Component.literal((String)("\u00a7" + chatFormatting.getChar())).append(" - ").append((Component)component)});
        }
        tooltipBuilder.build((AbstractWidget)this);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.setColor(this.isHoveredOrFocused() ? ChatFormatting.YELLOW.getColor() : 0x404040);
        int posX = this.getX() + (this.getWidth() - this.getFont().width((FormattedText)this.getMessage())) / 2;
        int posY = this.getY() + (this.getHeight() - 9) / 2;
        guiGraphics.drawString(this.getFont(), this.getMessage(), posX, posY, this.getColor(), false);
    }

    public boolean mouseClicked(MouseButtonEvent mouseButtonEvent, boolean doubleClick) {
        return false;
    }

    private static FormattedCharSequence getVisualOrder(FormattedText formattedText) {
        return formattedCharSink -> formattedText.visit((style, string) -> FormattedStringDecomposer.iterateFormatted(string, style, formattedCharSink) ? Optional.empty() : FormattedText.STOP_ITERATION, Style.EMPTY).isPresent();
    }
}

