/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyanvils.client;

import fuzs.easyanvils.EasyAnvils;
import fuzs.easyanvils.client.gui.screens.inventory.ModAnvilScreen;
import fuzs.easyanvils.client.gui.screens.inventory.NameTagEditScreen;
import fuzs.easyanvils.client.handler.BlockStateTranslator;
import fuzs.easyanvils.client.renderer.blockentity.AnvilRenderer;
import fuzs.easyanvils.config.ClientConfig;
import fuzs.easyanvils.config.ServerConfig;
import fuzs.easyanvils.handler.BlockConversionHandler;
import fuzs.easyanvils.init.ModRegistry;
import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.core.v1.context.BlockEntityRenderersContext;
import fuzs.puzzleslib.api.client.core.v1.context.BlockStateResolverContext;
import fuzs.puzzleslib.api.client.core.v1.context.MenuScreensContext;
import fuzs.puzzleslib.api.client.core.v1.context.RenderTypesContext;
import fuzs.puzzleslib.api.client.gui.v2.tooltip.ItemTooltipRegistry;
import fuzs.puzzleslib.api.client.renderer.v1.model.ModelLoadingHelper;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Executor;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class EasyAnvilsClient
implements ClientModConstructor {
    public void onClientSetup() {
        ItemTooltipRegistry.ITEM.registerItemTooltipLines((Object)Items.NAME_TAG, item -> {
            if (!((ClientConfig)EasyAnvils.CONFIG.get(ClientConfig.class)).nameTagTooltip) {
                return Collections.emptyList();
            }
            if (!EasyAnvils.CONFIG.getHolder(ServerConfig.class).isAvailable() || !((ServerConfig)EasyAnvils.CONFIG.get(ServerConfig.class)).miscellaneous.editNameTagsNoAnvil) {
                return Collections.emptyList();
            }
            return Collections.singletonList(NameTagEditScreen.DESCRIPTION_COMPONENT);
        });
    }

    public void onRegisterBlockStateResolver(BlockStateResolverContext context) {
        BlockConversionHandler.getBlockConversions().forEach((oldBlock, newBlock) -> context.registerBlockStateResolver(newBlock, (resourceManager, executor) -> ModelLoadingHelper.loadBlockState((ResourceManager)resourceManager, (Block)oldBlock, (Executor)executor), (loadedModels, blockStateConsumer) -> {
            Map<BlockState, BlockState> blockStates = BlockStateTranslator.INSTANCE.convertAllBlockStates((Block)newBlock, (Block)oldBlock);
            for (BlockState blockState : newBlock.getStateDefinition().getPossibleStates()) {
                BlockStateModel.UnbakedRoot model = (BlockStateModel.UnbakedRoot)loadedModels.models().get(blockStates.get(blockState));
                if (model != null) {
                    blockStateConsumer.accept(blockState, model);
                    continue;
                }
                EasyAnvils.LOGGER.warn("Missing model for variant: '{}'", (Object)blockState);
                blockStateConsumer.accept(blockState, ModelLoadingHelper.missingModel());
            }
        }));
    }

    public void onRegisterMenuScreens(MenuScreensContext context) {
        context.registerMenuScreen((MenuType)ModRegistry.ANVIL_MENU_TYPE.value(), ModAnvilScreen::new);
    }

    public void onRegisterBlockEntityRenderers(BlockEntityRenderersContext context) {
        context.registerBlockEntityRenderer((BlockEntityType)ModRegistry.ANVIL_BLOCK_ENTITY_TYPE.value(), AnvilRenderer::new);
    }

    public void onRegisterBlockRenderTypes(RenderTypesContext<Block> context) {
        for (Map.Entry entry : BlockConversionHandler.getBlockConversions().entrySet()) {
            context.registerChunkRenderType((Object)((Block)entry.getValue()), context.getChunkRenderType((Object)((Block)entry.getKey())));
        }
    }
}

