/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.processors;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.repurposedstructures.modinit.RSProcessors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WallVinePostProcessor
extends StructureProcessor {
    public static final MapCodec<WallVinePostProcessor> CODEC = Codec.FLOAT.fieldOf("probability").xmap(WallVinePostProcessor::new, wallVinePostProcessor -> Float.valueOf(wallVinePostProcessor.probability));
    private final float probability;

    public WallVinePostProcessor(float probability) {
        this.probability = probability;
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader worldView, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings structurePlacementData) {
        if (structureBlockInfoWorld.state().isAir()) {
            RandomSource random = structurePlacementData.getRandom(structureBlockInfoWorld.pos());
            ChunkAccess centerChunk = worldView.getChunk(structureBlockInfoWorld.pos());
            BlockState centerState = centerChunk.getBlockState(structureBlockInfoWorld.pos());
            if (random.nextFloat() < this.probability && centerState.isAir()) {
                BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
                for (Direction facing : Direction.Plane.HORIZONTAL) {
                    mutable.set((Vec3i)structureBlockInfoWorld.pos()).move(facing);
                    BlockState worldState = worldView.getChunk((BlockPos)mutable).getBlockState((BlockPos)mutable);
                    if (worldState.is(Blocks.SPAWNER) || !Block.isFaceFull((VoxelShape)worldState.getCollisionShape((BlockGetter)worldView, pos), (Direction)facing.getOpposite())) continue;
                    BlockState vineBlock = (BlockState)Blocks.VINE.defaultBlockState().setValue((Property)VineBlock.getPropertyForFace((Direction)facing), (Comparable)Boolean.valueOf(true));
                    centerChunk.setBlockState(structureBlockInfoWorld.pos(), vineBlock, 2);
                    break;
                }
            }
        }
        return structureBlockInfoWorld;
    }

    protected StructureProcessorType<?> getType() {
        return RSProcessors.WALL_VINE_POST_PROCESSOR.get();
    }
}

