/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.processors;

import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.repurposedstructures.modinit.RSProcessors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class RemoveFloatingBlocksProcessor
extends StructureProcessor {
    public static final MapCodec<RemoveFloatingBlocksProcessor> CODEC = MapCodec.unit(RemoveFloatingBlocksProcessor::new);

    private RemoveFloatingBlocksProcessor() {
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings structurePlacementData) {
        WorldGenRegion worldGenRegion;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().set((Vec3i)structureBlockInfoWorld.pos());
        if (levelReader instanceof WorldGenRegion && !(worldGenRegion = (WorldGenRegion)levelReader).getCenter().equals((Object)new ChunkPos((BlockPos)mutable))) {
            return structureBlockInfoWorld;
        }
        ChunkAccess cachedChunk = levelReader.getChunk((BlockPos)mutable);
        if (structureBlockInfoWorld.state().isAir() || !structureBlockInfoWorld.state().getFluidState().isEmpty()) {
            cachedChunk.setBlockState((BlockPos)mutable, structureBlockInfoWorld.state(), 2);
            BlockState aboveWorldState = levelReader.getBlockState((BlockPos)mutable.move(Direction.UP));
            while (mutable.getY() < levelReader.getHeight() && !aboveWorldState.canSurvive(levelReader, (BlockPos)mutable)) {
                cachedChunk.setBlockState((BlockPos)mutable, structureBlockInfoWorld.state(), 2);
                aboveWorldState = levelReader.getBlockState((BlockPos)mutable.move(Direction.UP));
            }
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockState sideBlock;
                mutable.set((Vec3i)structureBlockInfoWorld.pos());
                mutable.move(direction);
                ChunkPos chunkPos = new ChunkPos((BlockPos)mutable);
                ChunkAccess chunkAccess2 = cachedChunk;
                if (!chunkPos.equals((Object)cachedChunk.getPos())) {
                    chunkAccess2 = levelReader.getChunk((BlockPos)mutable);
                }
                if ((sideBlock = chunkAccess2.getBlockState((BlockPos)mutable)).canSurvive(levelReader, (BlockPos)mutable)) continue;
                chunkAccess2.setBlockState((BlockPos)mutable, structureBlockInfoWorld.state(), 2);
            }
        }
        return structureBlockInfoWorld;
    }

    protected StructureProcessorType<?> getType() {
        return RSProcessors.REMOVE_FLOATING_BLOCKS_PROCESSOR.get();
    }
}

