/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.processors;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.repurposedstructures.modinit.RSProcessors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class FloodWithWaterProcessor
extends StructureProcessor {
    public static final MapCodec<FloodWithWaterProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("flood_level").forGetter(config -> config.floodLevel)).apply((Applicative)instance, instance.stable(FloodWithWaterProcessor::new)));
    private final int floodLevel;

    private FloodWithWaterProcessor(int floodLevel) {
        this.floodLevel = floodLevel;
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings structurePlacementData) {
        WorldGenRegion worldGenRegion;
        if (structureBlockInfoWorld.state().getFluidState().is(FluidTags.WATER)) {
            this.tickWaterFluid(levelReader, structureBlockInfoWorld);
            return structureBlockInfoWorld;
        }
        if (levelReader instanceof WorldGenRegion && !(worldGenRegion = (WorldGenRegion)levelReader).getCenter().equals((Object)new ChunkPos(structureBlockInfoWorld.pos()))) {
            return structureBlockInfoWorld;
        }
        if (structureBlockInfoWorld.pos().getY() <= this.floodLevel) {
            boolean flooded = false;
            if (structureBlockInfoWorld.state().isAir() || structureBlockInfoWorld.state().is(BlockTags.FLOWER_POTS) || structureBlockInfoWorld.state().is(BlockTags.BUTTONS) || structureBlockInfoWorld.state().canBeReplaced((Fluid)Fluids.WATER)) {
                structureBlockInfoWorld = new StructureTemplate.StructureBlockInfo(structureBlockInfoWorld.pos(), Blocks.WATER.defaultBlockState(), null);
                this.tickWaterFluid(levelReader, structureBlockInfoWorld);
                flooded = true;
            } else if (structureBlockInfoWorld.state().hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
                structureBlockInfoWorld = new StructureTemplate.StructureBlockInfo(structureBlockInfoWorld.pos(), (BlockState)structureBlockInfoWorld.state().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)), structureBlockInfoWorld.nbt());
                this.tickWaterFluid(levelReader, structureBlockInfoWorld);
                flooded = true;
            } else if (structureBlockInfoWorld.state().getBlock() instanceof BushBlock) {
                structureBlockInfoWorld = new StructureTemplate.StructureBlockInfo(structureBlockInfoWorld.pos(), Blocks.WATER.defaultBlockState(), null);
                this.tickWaterFluid(levelReader, structureBlockInfoWorld);
                flooded = true;
            }
            if (flooded) {
                ChunkPos currentChunkPos = new ChunkPos(structureBlockInfoWorld.pos());
                ChunkAccess currentChunk = levelReader.getChunk(currentChunkPos.x, currentChunkPos.z);
                BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
                for (Direction direction : Direction.values()) {
                    BlockState neighboringBlock;
                    if (direction == Direction.UP) continue;
                    mutable.set((Vec3i)structureBlockInfoWorld.pos()).move(direction);
                    if (currentChunkPos.x != mutable.getX() >> 4 || currentChunkPos.z != mutable.getZ() >> 4) {
                        currentChunk = levelReader.getChunk((BlockPos)mutable);
                        currentChunkPos = new ChunkPos((BlockPos)mutable);
                    }
                    if ((neighboringBlock = currentChunk.getBlockState((BlockPos)mutable)).canOcclude() || !neighboringBlock.getFluidState().isEmpty()) continue;
                    currentChunk.setBlockState((BlockPos)mutable, Blocks.CRACKED_STONE_BRICKS.defaultBlockState(), 2);
                }
            }
        }
        return structureBlockInfoWorld;
    }

    private void tickWaterFluid(LevelReader worldView, StructureTemplate.StructureBlockInfo structureBlockInfoWorld) {
        ((LevelAccessor)worldView).scheduleTick(structureBlockInfoWorld.pos(), (Fluid)Fluids.WATER, 1);
    }

    protected StructureProcessorType<?> getType() {
        return RSProcessors.FLOOD_WITH_WATER_PROCESSOR.get();
    }
}

